/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.tuleap_api.client.GitApi;
import io.jenkins.plugins.tuleap_api.client.GitFileContent;
import io.jenkins.plugins.tuleap_api.client.GitTreeContent;
import io.jenkins.plugins.tuleap_api.client.exceptions.git.FileContentNotFoundException;
import io.jenkins.plugins.tuleap_api.client.exceptions.git.TreeNotFoundException;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMFile;

public class TuleapSCMFile
extends SCMFile {
    private final GitApi gitApi;
    private final String repositoryId;
    private final String ref;
    private final TuleapAccessToken tuleapAccessToken;
    private final boolean isDirectory;

    public TuleapSCMFile(GitApi gitApi, String repositoryId, String ref, TuleapAccessToken tuleapAccessToken) {
        this.gitApi = gitApi;
        this.repositoryId = repositoryId;
        this.ref = ref;
        this.tuleapAccessToken = tuleapAccessToken;
        this.isDirectory = true;
        this.type(SCMFile.Type.DIRECTORY);
    }

    private TuleapSCMFile(TuleapSCMFile parent, String name, SCMFile.Type type) {
        super((SCMFile)parent, name);
        this.gitApi = parent.gitApi;
        this.repositoryId = parent.repositoryId;
        this.tuleapAccessToken = parent.tuleapAccessToken;
        this.ref = parent.ref;
        this.isDirectory = type == SCMFile.Type.DIRECTORY;
        this.type(type);
    }

    private TuleapSCMFile(TuleapSCMFile parent, String name, Boolean isDirectory) {
        super((SCMFile)parent, name);
        this.gitApi = parent.gitApi;
        this.tuleapAccessToken = parent.tuleapAccessToken;
        this.repositoryId = parent.repositoryId;
        this.ref = parent.ref;
        this.isDirectory = isDirectory;
    }

    @NonNull
    protected SCMFile newChild(@NonNull String name, boolean isDirectory) {
        return new TuleapSCMFile(this, name, isDirectory);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        List<GitTreeContent> treeContent;
        if (!this.isDirectory()) {
            throw new IOException("Cannot get children from a regular file");
        }
        try {
            treeContent = this.fetchTree();
        }
        catch (TreeNotFoundException e) {
            throw new IOException("Tree content cannot be retrieved: " + e.getMessage());
        }
        return treeContent.stream().map(item -> {
            SCMFile.Type type;
            switch (item.getType()) {
                case TREE: {
                    type = SCMFile.Type.DIRECTORY;
                    break;
                }
                case BLOB: {
                    type = SCMFile.Type.REGULAR_FILE;
                    break;
                }
                case SYMLINK: {
                    type = SCMFile.Type.LINK;
                    break;
                }
                default: {
                    type = SCMFile.Type.OTHER;
                }
            }
            return new TuleapSCMFile(this, item.getName(), type);
        }).collect(Collectors.toList());
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (this.isDirectory) {
            return SCMFile.Type.DIRECTORY;
        }
        try {
            this.gitApi.getFileContent(this.repositoryId, this.ref, this.getPath(), this.tuleapAccessToken);
            return SCMFile.Type.REGULAR_FILE;
        }
        catch (FileContentNotFoundException e) {
            try {
                this.gitApi.getTree(this.repositoryId, this.ref, this.getPath(), this.tuleapAccessToken);
                return SCMFile.Type.DIRECTORY;
            }
            catch (TreeNotFoundException treeNotFoundException) {
                return SCMFile.Type.NONEXISTENT;
            }
        }
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        if (this.isDirectory()) {
            throw new IOException("Cannot get raw content from a directory");
        }
        try {
            byte[] decodedByteContent = Base64.getDecoder().decode(this.fetchFile().getContent());
            return new ByteArrayInputStream(decodedByteContent);
        }
        catch (FileContentNotFoundException e) {
            throw new IOException("File not found: " + e.getMessage());
        }
    }

    private List<GitTreeContent> fetchTree() throws TreeNotFoundException {
        return this.gitApi.getTree(this.repositoryId, this.ref, this.getPath(), this.tuleapAccessToken);
    }

    private GitFileContent fetchFile() throws FileContentNotFoundException {
        return this.gitApi.getFileContent(this.repositoryId, this.ref, this.getPath(), this.tuleapAccessToken);
    }
}

