/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.tuleap_api.client.GitApi;
import io.jenkins.plugins.tuleap_api.client.GitCommit;
import io.jenkins.plugins.tuleap_api.client.GitPullRequest;
import io.jenkins.plugins.tuleap_api.client.PullRequest;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientCommandConfigurer;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientRawCmd;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapBranches;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapGitRepository;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapProject;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.tuleap_git_branch_source.Messages;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapBranchSCMHead;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapBranchSCMRevision;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapLink;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapPullRequestRevision;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapPullRequestSCMHead;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMBuilder;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMSourceContext;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMSourceRequest;
import org.jenkinsci.plugins.tuleap_git_branch_source.config.TuleapConnector;
import org.jenkinsci.plugins.tuleap_git_branch_source.config.TuleapSCMFileSystem;
import org.jenkinsci.plugins.tuleap_git_branch_source.helpers.TuleapApiRetriever;
import org.jenkinsci.plugins.tuleap_git_branch_source.trait.TuleapBranchDiscoveryTrait;
import org.jenkinsci.plugins.tuleap_git_branch_source.trait.TuleapOriginPullRequestDiscoveryTrait;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class TuleapSCMSource
extends AbstractGitSCMSource {
    private static final Logger LOGGER = Logger.getLogger(TuleapSCMSource.class.getName());
    private String projectId;
    private TuleapGitRepository repository;
    private TuleapProject project;
    private String repositoryPath;
    private String remoteUrl;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    private String credentialsId;
    private TuleapAccessToken credentials;

    @DataBoundConstructor
    public TuleapSCMSource(TuleapProject project, TuleapGitRepository repository) {
        this.repository = repository;
        this.project = project;
        this.projectId = String.valueOf(project.getId());
        this.repositoryPath = repository.getPath();
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        TuleapLink repoLink;
        ArrayList<Action> result = new ArrayList<Action>();
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable && (repoLink = (TuleapLink)((Actionable)owner).getAction(TuleapLink.class)) != null) {
            if (head instanceof TuleapBranchSCMHead) {
                String canonicalRepoName = this.repositoryPath.replace(this.project.getShortname() + "/", "");
                String url = repoLink.getUrl() + "?p=" + canonicalRepoName + "&a=shortlog&h=" + head.getName();
                result.add(new TuleapLink("icon-git-branch", url));
            } else if (head instanceof TuleapPullRequestSCMHead) {
                TuleapPullRequestSCMHead tuleapPullRequestSCMHead = (TuleapPullRequestSCMHead)head;
                String prUrl = this.getGitBaseUri() + "?action=pull-requests&repo_id=" + this.repository.getId() + "&group_id=" + this.projectId + "#/pull-requests/" + tuleapPullRequestSCMHead.getId() + "/overview";
                result.add(new TuleapLink("icon-git-branch", prUrl));
            }
        }
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        result.add(new TuleapLink("icon-git-repo", this.getGitBaseUri() + this.repositoryPath.replace(".git", "")));
        return result;
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (final TuleapSCMSourceRequest request = ((TuleapSCMSourceContext)new TuleapSCMSourceContext(criteria, observer).withTraits(this.traits)).newRequest((SCMSource)this, listener);){
            TuleapAccessToken credentials = TuleapConnector.lookupScanCredentials((Item)this.getOwner(), this.getApiBaseUri(), this.getCredentialsId());
            this.setCredentials(credentials);
            this.setRemoteUrl(this.getGitBaseUri() + this.repositoryPath);
            if (request.isFetchBranches()) {
                LOGGER.info(String.format("Fecthing branches for repository at %s", this.repositoryPath));
                Stream branches = (Stream)TuleapClientCommandConfigurer.newInstance((String)this.getApiBaseUri()).withCredentials(credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.Branches(this.repository.getId())).configure().call();
                int count = 0;
                for (TuleapBranches branch : branches.collect(Collectors.toList())) {
                    ++count;
                    request.listener().getLogger().format("Search at '%s'", branch.getName());
                    TuleapBranchSCMHead tuleapBranchSCMHead = new TuleapBranchSCMHead(branch.getName());
                    if (!request.process(tuleapBranchSCMHead, head -> new TuleapBranchSCMRevision(head, branch.getCommit().getId()), (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<TuleapBranchSCMHead, TuleapBranchSCMRevision>(){

                        @NotNull
                        public SCMSourceCriteria.Probe create(@NotNull TuleapBranchSCMHead head, @Nullable TuleapBranchSCMRevision revisionInfo) throws IOException, InterruptedException {
                            return TuleapSCMSource.this.createProbe(head, (SCMRevision)revisionInfo);
                        }
                    }, new SCMSourceRequest.Witness[]{new OFWitness(listener)})) continue;
                    request.listener().getLogger().format("%n  %d branches were processed (query completed)%n", count).println();
                }
            }
            if (request.isRetrievePullRequests()) {
                request.listener().getLogger().format("Fetching pull requests for repository at %s %n", this.repositoryPath);
                GitApi gitApi = TuleapApiRetriever.getGitApi();
                List partialPullRequests = gitApi.getPullRequests(Integer.toString(this.repository.getId()), this.credentials);
                int prCount = 0;
                for (GitPullRequest partialPullRequest : partialPullRequests) {
                    GitCommit targetLastCommit;
                    TuleapBranchSCMHead targetBranch;
                    TuleapPullRequestSCMHead tlpPRSCMHead;
                    boolean isFork;
                    PullRequest pullRequest = TuleapApiRetriever.getPullRequestApi().getPullRequest(partialPullRequest.getId(), this.credentials);
                    request.listener().getLogger().format("Check the PR id: '%s' %n", pullRequest.getId());
                    ++prCount;
                    boolean bl = isFork = !pullRequest.getSourceRepository().getId().equals(pullRequest.getDestinationRepository().getId());
                    if (isFork && !request.isRetrieveForkPullRequests()) {
                        request.listener().getLogger().format("PR id: %s is skipped, Pull Requests from fork are excluded %n", pullRequest.getId());
                        continue;
                    }
                    if (!isFork && !request.isRetrieveOriginPullRequests()) {
                        request.listener().getLogger().format("PR id: %s is skipped, Pull Requests from same origin are excluded %n", pullRequest.getId());
                        continue;
                    }
                    SCMHeadOrigin.Default origin = SCMHeadOrigin.DEFAULT;
                    Integer originRepositoryId = this.repository.getId();
                    Integer targetRepositoryId = this.repository.getId();
                    if (isFork) {
                        origin = new SCMHeadOrigin.Fork(pullRequest.getSourceRepository().getName());
                        originRepositoryId = pullRequest.getSourceRepository().getId();
                        targetRepositoryId = pullRequest.getDestinationRepository().getId();
                    }
                    if (!request.process(tlpPRSCMHead = new TuleapPullRequestSCMHead(partialPullRequest, (SCMHeadOrigin)origin, targetBranch = new TuleapBranchSCMHead(pullRequest.getDestinationBranch()), originRepositoryId, targetRepositoryId, pullRequest.getHeadReference()), arg_0 -> TuleapSCMSource.lambda$retrieve$1(targetLastCommit = gitApi.getCommit(Integer.toString(this.repository.getId()), targetBranch.getName(), this.credentials), partialPullRequest, arg_0), (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<TuleapPullRequestSCMHead, TuleapPullRequestRevision>(){

                        @NotNull
                        public SCMSourceCriteria.Probe create(@NotNull TuleapPullRequestSCMHead head, @Nullable TuleapPullRequestRevision revisionInfo) throws IOException, InterruptedException {
                            boolean isTrusted = request.isTrusted(head);
                            if (!isTrusted) {
                                listener.getLogger().println("This pull request is not from a trusted source or it is from a fork repository");
                            }
                            return TuleapSCMSource.this.createProbe(isTrusted ? head : head.getTarget(), (SCMRevision)revisionInfo);
                        }
                    }, new SCMSourceRequest.Witness[]{new OFWitness(listener)})) continue;
                    request.listener().getLogger().format("%n  %d branches were processed (query completed)%n", prCount).println();
                }
            }
        }
    }

    @NotNull
    protected SCMProbe createProbe(final @NonNull SCMHead head, SCMRevision revision) throws IOException {
        TuleapSCMFileSystem.BuilderImpl tuleapFileSystemBuilder = (TuleapSCMFileSystem.BuilderImpl)((Object)ExtensionList.lookup(SCMFileSystem.Builder.class).get(TuleapSCMFileSystem.BuilderImpl.class));
        if (tuleapFileSystemBuilder == null) {
            throw new IOException("Error while retrieving the tfs");
        }
        final SCMFileSystem fileSystem = tuleapFileSystemBuilder.build((SCMSource)this, head, revision);
        return new SCMProbe(){

            @NotNull
            public SCMProbeStat stat(@NotNull String path) throws IOException {
                try {
                    return SCMProbeStat.fromType((SCMFile.Type)fileSystem.child(path).getType());
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted", e);
                }
            }

            public void close() throws IOException {
                Objects.requireNonNull(fileSystem).close();
            }

            public String name() {
                return head.getName();
            }

            public long lastModified() {
                try {
                    return fileSystem == null ? 0L : fileSystem.lastModified();
                }
                catch (IOException | InterruptedException exception) {
                    return 0L;
                }
            }
        };
    }

    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (revision instanceof TuleapPullRequestRevision) {
            TuleapPullRequestSCMHead head = (TuleapPullRequestSCMHead)revision.getHead();
            try (TuleapSCMSourceRequest request = ((TuleapSCMSourceContext)new TuleapSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).newRequest((SCMSource)this, listener);){
                if (request.isTrusted(head)) {
                    SCMRevision sCMRevision = revision;
                    return sCMRevision;
                }
            }
            TuleapPullRequestRevision rev = (TuleapPullRequestRevision)revision;
            listener.getLogger().format("Loading trusted Jenkins files from target branch %s at %s rather than %s%n", head.getTarget().getName(), rev.getTarget(), rev.getOrigin().getHead().getName());
            return new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), rev.getTargetHash());
        }
        return revision;
    }

    protected SCMRevision retrieve(SCMHead head, TaskListener listener) throws IOException, InterruptedException {
        if (head instanceof TuleapBranchSCMHead) {
            Optional<Object> revision = Optional.empty();
            Stream branches = (Stream)TuleapClientCommandConfigurer.newInstance((String)this.getApiBaseUri()).withCredentials(this.credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.Branches(this.repository.getId())).configure().call();
            Optional<TuleapBranches> branch = branches.filter(b -> b.getName().equals(head.getName())).findFirst();
            if (branch.isPresent()) {
                revision = Optional.of(branch.get().getCommit().getId());
            } else {
                listener.getLogger().format("Cannot find the branch %s in repo : %s", head.getName(), this.repositoryPath);
            }
            if (revision.isPresent()) {
                return new TuleapBranchSCMRevision(head, (String)revision.get());
            }
        } else if (head instanceof TuleapPullRequestSCMHead) {
            TuleapPullRequestSCMHead tlpSCMHead = (TuleapPullRequestSCMHead)head;
            PullRequest pullRequest = TuleapApiRetriever.getPullRequestApi().getPullRequest(tlpSCMHead.getId(), this.credentials);
            String targetReference = pullRequest.getDestinationReference();
            return new TuleapPullRequestRevision(tlpSCMHead, new TuleapBranchSCMRevision(tlpSCMHead.getTarget(), targetReference), new TuleapBranchSCMRevision(new TuleapBranchSCMHead(tlpSCMHead.getOriginName()), pullRequest.getHead().getId()));
        }
        listener.getLogger().format("Cannot resolve the hash of the revision in branch %s%n", head.getName());
        return null;
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        if (super.isCategoryEnabled(category)) {
            for (SCMSourceTrait trait : this.traits) {
                if (!trait.isCategoryEnabled(category)) continue;
                return true;
            }
        }
        return false;
    }

    public void setCredentials(TuleapAccessToken credentials) {
        this.credentials = credentials;
    }

    @NotNull
    public SCM build(@NonNull SCMHead scmHead, @CheckForNull SCMRevision scmRevision) {
        String repositoryUri = this.getGitBaseUri() + this.project.getShortname() + "/" + this.repository.getName();
        return ((TuleapSCMBuilder)new TuleapSCMBuilder(scmHead, scmRevision, this.remoteUrl, this.credentialsId, repositoryUri).withTraits(this.traits)).build();
    }

    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    public String getRemote() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getprojectId() {
        return this.projectId;
    }

    @DataBoundSetter
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    @DataBoundSetter
    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getApiBaseUri() {
        return TuleapConfiguration.get().getApiBaseUrl();
    }

    public String getGitBaseUri() {
        return TuleapConfiguration.get().getGitBaseUrl();
    }

    public TuleapGitRepository getTuleapGitRepository() {
        return this.repository;
    }

    private static /* synthetic */ TuleapPullRequestRevision lambda$retrieve$1(GitCommit targetLastCommit, GitPullRequest partialPullRequest, TuleapPullRequestSCMHead head) throws IOException, InterruptedException {
        return new TuleapPullRequestRevision(head, new TuleapBranchSCMRevision(head.getTarget(), targetLastCommit.getHash()), new TuleapBranchSCMRevision(new TuleapBranchSCMHead(head.getOriginName()), partialPullRequest.getHead().getId()));
    }

    private static class OFWitness
    implements SCMSourceRequest.Witness {
        private final TaskListener listener;

        public OFWitness(TaskListener listener) {
            this.listener = listener;
        }

        public void record(@NonNull SCMHead scmHead, @CheckForNull SCMRevision revision, boolean isMatch) {
            if (isMatch) {
                this.listener.getLogger().format("    Met criteria%n", new Object[0]);
            } else {
                this.listener.getLogger().format("    Does not meet criteria%n", new Object[0]);
            }
        }
    }

    @Symbol(value={"Tuleap"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return "Tuleap";
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new TuleapBranchDiscoveryTrait(), new TuleapOriginPullRequestDiscoveryTrait(), new RefSpecsSCMSourceTrait(new String[0])});
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            return TuleapConnector.checkCredentials(item, apiUri, credentialsId);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            return TuleapConnector.listScanCredentials(context, apiUri, credentialsId, false);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillProjectIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String projectId, @QueryParameter String credentialsId) throws IOException {
            String apiUri = TuleapConfiguration.get().getApiBaseUrl();
            TuleapAccessToken credentials = TuleapConnector.lookupScanCredentials(context, apiUri, credentialsId);
            ListBoxModel result = new ListBoxModel();
            Optional project = (Optional)TuleapClientCommandConfigurer.newInstance((String)apiUri).withCredentials(credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.ProjectById(projectId)).configure().call();
            if (project.isPresent()) {
                ListBoxModel.Option newItem = new ListBoxModel.Option(((TuleapProject)project.get()).getShortname(), String.valueOf(((TuleapProject)project.get()).getId()));
                result.add((Object)newItem);
            }
            return result;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillRepositoryPathItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String projectId, @QueryParameter String credentialsId, @QueryParameter String repositoryPath) throws IOException {
            ListBoxModel result = new ListBoxModel();
            String apiBaseUrl = TuleapConfiguration.get().getApiBaseUrl();
            TuleapAccessToken credentials = TuleapConnector.lookupScanCredentials(context, apiBaseUrl, credentialsId);
            Optional<TuleapGitRepository> repo = ((Stream)TuleapClientCommandConfigurer.newInstance((String)apiBaseUrl).withCredentials(credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.AllRepositoriesByProject(projectId)).configure().call()).distinct().filter(r -> r.getPath().equals(repositoryPath)).findFirst();
            if (repo.isPresent()) {
                ListBoxModel.Option newItem = new ListBoxModel.Option(repo.get().getName(), repo.get().getPath());
                result.add((Object)newItem);
            }
            return result;
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, new ChangeRequestSCMHeadCategory(Messages._TuleapSCMSource_ChangeRequestCategory())};
        }
    }
}

