/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import io.jenkins.plugins.tuleap_api.client.GitApi;
import io.jenkins.plugins.tuleap_api.client.TuleapApiGuiceModule;
import io.jenkins.plugins.tuleap_api.client.internals.entities.TuleapBuildStatus;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.tuleap_git_branch_source.notify.TuleapPipelineStatusHandler;
import org.jenkinsci.plugins.tuleap_git_branch_source.notify.TuleapPipelineStatusNotifier;

public class TuleapPipelineWatcher {
    private static final Logger LOGGER = Logger.getLogger(TuleapPipelineWatcher.class.getName());

    private static TuleapPipelineStatusHandler getHandler() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapApiGuiceModule()});
        return new TuleapPipelineStatusHandler(new TuleapPipelineStatusNotifier((GitApi)injector.getInstance(GitApi.class)));
    }

    @Extension
    public static class TuleapJobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, @NonNull TaskListener listener) {
            LOGGER.log(Level.INFO, String.format("Tuleap build: Complete > %s", build.getFullDisplayName()));
            Result buildResult = build.getResult();
            TuleapBuildStatus status = buildResult == Result.SUCCESS ? TuleapBuildStatus.success : TuleapBuildStatus.failure;
            TuleapPipelineWatcher.getHandler().handleCommitNotification(build, listener.getLogger(), status);
        }
    }

    @Extension
    public static class TuleapJobCheckOutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) {
            LOGGER.log(Level.INFO, String.format("Tuleap build: Checkout > %s", build.getFullDisplayName()));
            TuleapPipelineWatcher.getHandler().handleCommitNotification(build, listener.getLogger(), TuleapBuildStatus.pending);
        }
    }
}

