/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source.webhook.processor;

import com.google.gson.Gson;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.check.TuleapWebHookChecker;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.exceptions.BranchNotFoundException;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.exceptions.RepositoryNotFoundException;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.exceptions.RepositoryScanFailedException;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.exceptions.TuleapProjectNotFoundException;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.helper.TuleapWebHookHelper;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.model.WebHookRepresentation;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.processor.JobFinder;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.processor.TuleapWebHookProcessor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

public class TuleapWebHookProcessorImpl
implements TuleapWebHookProcessor {
    private static final Logger LOGGER = Logger.getLogger(TuleapWebHookProcessor.class.getName());
    private final Gson gson;
    private TuleapWebHookChecker webHookChecker;
    private JobFinder jobFinder;
    private TuleapWebHookHelper helper;

    @Inject
    public TuleapWebHookProcessorImpl(Gson gson, TuleapWebHookChecker webHookChecker, JobFinder jobFinder, TuleapWebHookHelper helper) {
        this.gson = gson;
        this.webHookChecker = webHookChecker;
        this.jobFinder = jobFinder;
        this.helper = helper;
    }

    @Override
    public HttpResponse process(StaplerRequest request) throws IOException {
        String decodedPayload;
        if (!this.webHookChecker.checkRequestHeaderContentType(request.getContentType())) {
            return HttpResponses.error((int)400, (String)"Content type not supported");
        }
        String payload = this.helper.getStringPayload(request);
        if (payload.isEmpty()) {
            return HttpResponses.error((int)400, (String)"Jenkins job cannot be triggered. The request is empty");
        }
        try {
            decodedPayload = this.helper.getUTF8DecodedPayload(payload);
        }
        catch (UnsupportedEncodingException e) {
            return HttpResponses.error((int)500, (String)"Error while decoding the payload");
        }
        LOGGER.log(Level.FINEST, "Checking the payload content...");
        WebHookRepresentation representation = (WebHookRepresentation)this.gson.fromJson(decodedPayload, WebHookRepresentation.class);
        if (representation == null || !this.webHookChecker.checkPayloadContent(representation)) {
            LOGGER.log(Level.WARNING, "Bad payload format");
            return HttpResponses.error((int)400, (String)"Bad payload format");
        }
        try {
            this.jobFinder.triggerConcernedJob(representation);
        }
        catch (BranchNotFoundException | RepositoryNotFoundException | RepositoryScanFailedException | TuleapProjectNotFoundException e) {
            LOGGER.log(Level.WARNING, e.toString());
        }
        return HttpResponses.ok();
    }
}

