/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientCommandConfigurer;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientRawCmd;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapGitRepository;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapProject;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCategory;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.UncategorizedSCMSourceCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import jenkins.scm.impl.trait.WildcardSCMSourceFilterTrait;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.tuleap_git_branch_source.Messages;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapLink;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapProjectMetadataAction;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMNavigatorContext;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMNavigatorRequest;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMSource;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMSourceBuilder;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMSourceContext;
import org.jenkinsci.plugins.tuleap_git_branch_source.config.TuleapConnector;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class TuleapSCMNavigator
extends SCMNavigator {
    private static final String TULEAP_FORK_PARTIAL_PATH = "/u/";
    private String tuleapProjectId;
    private String projectId;
    private List<SCMTrait<? extends SCMTrait<?>>> traits;
    private String credentialsId;
    private String apiUri;
    private String gitBaseUri;
    private Map<String, TuleapGitRepository> repositories = new HashMap<String, TuleapGitRepository>();
    private TuleapProject project;

    @DataBoundConstructor
    public TuleapSCMNavigator(String tuleapProjectId) {
        this.tuleapProjectId = tuleapProjectId;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.projectId != null) {
            this.tuleapProjectId = this.projectId;
            this.projectId = null;
        }
        return this;
    }

    @NonNull
    protected String id() {
        return TuleapConfiguration.get().getDomainUrl() + "::" + this.tuleapProjectId;
    }

    public void visitSources(SCMSourceObserver observer) throws IOException, InterruptedException {
        TaskListener listener = observer.getListener();
        listener.getLogger().printf("Visit Sources of %s...%n", this.getTuleapProjectId());
        TuleapAccessToken credentials = TuleapConnector.lookupScanCredentials((Item)observer.getContext(), this.getApiUri(), this.credentialsId);
        try (TuleapSCMNavigatorRequest request = ((TuleapSCMNavigatorContext)new TuleapSCMNavigatorContext().withTraits(this.traits)).newRequest(this, observer);){
            WitnessImpl witness = new WitnessImpl(listener, this);
            Optional project = (Optional)TuleapClientCommandConfigurer.newInstance((String)this.getApiUri()).withCredentials(credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.ProjectById(this.tuleapProjectId)).configure().call();
            if (!project.isPresent()) {
                listener.getLogger().format("No project match projectId " + this.tuleapProjectId + "... it's weird%n", new Object[0]);
                return;
            }
            this.project = (TuleapProject)project.get();
            Stream repos = (Stream)TuleapClientCommandConfigurer.newInstance((String)this.getApiUri()).withCredentials(credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.AllRepositoriesByProject(this.tuleapProjectId)).configure().call();
            for (TuleapGitRepository repo : repos.collect(Collectors.toList())) {
                if (!repo.getPath().contains(TULEAP_FORK_PARTIAL_PATH)) {
                    this.repositories.put(repo.getName(), repo);
                    SourceFactory sourceFactory = new SourceFactory(request, this.project, repo);
                    if (!request.process(repo.getName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) continue;
                    listener.getLogger().format("%d repositories were processed (query completed)%n", witness.getCount());
                    continue;
                }
                listener.getLogger().format("%s is ignored because it is a user fork%n", repo.getName());
            }
            listener.getLogger().format("%d repositories were processed%n", witness.getCount());
        }
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, @CheckForNull SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().printf("Looking up details of %s...%n", this.getTuleapProjectId());
        ArrayList<Action> actions = new ArrayList<Action>();
        TuleapAccessToken credentials = TuleapConnector.lookupScanCredentials((Item)owner, this.getApiUri(), this.credentialsId);
        Optional project = (Optional)TuleapClientCommandConfigurer.newInstance((String)this.getApiUri()).withCredentials(credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.ProjectById(this.tuleapProjectId)).configure().call();
        if (project.isPresent()) {
            actions.add((Action)new TuleapProjectMetadataAction((TuleapProject)project.get()));
            actions.add(new TuleapLink("icon-tuleap-logo", TuleapConfiguration.get().getDomainUrl() + "/projects/" + ((TuleapProject)project.get()).getShortname()));
        }
        return actions;
    }

    @NonNull
    public List<SCMTrait<? extends SCMTrait<?>>> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMTrait<? extends SCMTrait<?>>> traits) {
        this.traits = traits != null ? new ArrayList(traits) : new ArrayList();
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @CheckForNull
    public String getApiUri() {
        if (StringUtils.isBlank((CharSequence)this.apiUri)) {
            this.apiUri = TuleapConfiguration.get().getApiBaseUrl();
        }
        return this.apiUri;
    }

    @CheckForNull
    public String getGitBaseUri() {
        if (StringUtils.isBlank((CharSequence)this.gitBaseUri)) {
            this.gitBaseUri = TuleapConfiguration.get().getGitBaseUrl();
        }
        return this.gitBaseUri;
    }

    public String getTuleapProjectId() {
        return this.tuleapProjectId;
    }

    @DataBoundSetter
    public void setTuleapProjectId(String tuleapProjectId) {
        this.tuleapProjectId = tuleapProjectId;
    }

    public Map<String, TuleapGitRepository> getRepositories() {
        return this.repositories;
    }

    public boolean isIncludeExcludesDefault() {
        String includes = "*";
        String excludes = "*";
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof WildcardSCMHeadFilterTrait)) continue;
            includes = ((WildcardSCMHeadFilterTrait)sCMTrait).getIncludes();
            excludes = ((WildcardSCMHeadFilterTrait)sCMTrait).getExcludes();
        }
        return "*".equals(includes) && "*".equals(excludes);
    }

    private class SourceFactory
    implements SCMNavigatorRequest.SourceLambda {
        private final TuleapSCMNavigatorRequest request;
        private final TuleapGitRepository repo;
        private final TuleapProject project;

        public SourceFactory(TuleapSCMNavigatorRequest request, TuleapProject project, TuleapGitRepository repo) {
            this.request = request;
            this.repo = repo;
            this.project = project;
        }

        @NonNull
        public SCMSource create(@NonNull String repositoryName) throws IOException, InterruptedException {
            return ((TuleapSCMSourceBuilder)new TuleapSCMSourceBuilder(TuleapSCMNavigator.this.getId() + repositoryName, TuleapSCMNavigator.this.credentialsId, this.project, this.repo).withRequest(this.request)).build();
        }
    }

    private static class WitnessImpl
    implements SCMNavigatorRequest.Witness {
        private final TaskListener listener;
        @GuardedBy(value="this")
        private int count;
        private TuleapSCMNavigator navigator;

        private WitnessImpl(TaskListener listener, TuleapSCMNavigator navigator) {
            this.listener = listener;
            this.navigator = navigator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(@NonNull String name, boolean isMatch) {
            if (isMatch) {
                this.listener.getLogger().format("Proposing %s%n", name);
                WitnessImpl witnessImpl = this;
                synchronized (witnessImpl) {
                    ++this.count;
                }
            } else {
                TuleapGitRepository repo = this.navigator.getRepositories().get(name);
                this.listener.getLogger().format("Ignoring %s (reason : private user fork is excluded, URL : %s)%n", name, repo.getPath());
            }
        }

        public synchronized int getCount() {
            return this.count;
        }
    }

    @Symbol(value={"tuleap"})
    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        @Inject
        private TuleapSCMSource.DescriptorImpl delegate;

        public String getPronoun() {
            return Messages.SCMNavigator_pronoun();
        }

        public SCMNavigator newInstance(@CheckForNull String projectId) {
            TuleapSCMNavigator navigator = new TuleapSCMNavigator(projectId);
            List<SCMTrait<SCMTrait<?>>> someTraits = this.getTraitsDefaults();
            someTraits.add((SCMTrait<SCMTrait<?>>)new WildcardSCMSourceFilterTrait("", ""));
            navigator.setTraits(someTraits);
            return navigator;
        }

        @NonNull
        public String getDisplayName() {
            return "Tuleap Project";
        }

        @NonNull
        protected SCMSourceCategory[] createCategories() {
            return new SCMSourceCategory[]{new UncategorizedSCMSourceCategory(Messages._SCMNavigator_depotSourceCategory())};
        }

        @NonNull
        public String getDescription() {
            return Messages.SCMNavigator_description();
        }

        public String getIconFilePathPattern() {
            return "plugin/tuleap-git-branch-source/images/:size/tuleap-scmnavigator.png";
        }

        public String getIconClassName() {
            return "icon-tuleap-scm-navigator";
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            return TuleapConnector.checkCredentials(context, apiUri, credentialsId);
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckTuleapProjectId(@QueryParameter String tuleapProjectId) {
            if (Util.fixEmpty((String)tuleapProjectId) == null) {
                return FormValidation.error((String)Messages.SCMNavigator_aTuleapProjectIsRequiredWarning());
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            return TuleapConnector.listScanCredentials(context, apiUri, credentialsId, true);
        }

        public List<SCMTrait<? extends SCMTrait<?>>> getTraitsDefaults() {
            ArrayList result = new ArrayList();
            result.addAll(this.delegate.getTraitsDefaults());
            return result;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillApiUriItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("Tuleap API", TuleapConfiguration.get().getApiBaseUrl());
            return result;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillTuleapProjectIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String credentialsId) throws IOException {
            String apiUri = TuleapConfiguration.get().getApiBaseUrl();
            TuleapAccessToken credentials = TuleapConnector.lookupScanCredentials(context, apiUri, credentialsId);
            StandardListBoxModel result = new StandardListBoxModel();
            result.includeEmptyValue();
            try {
                ((Stream)TuleapClientCommandConfigurer.newInstance((String)apiUri).withCredentials(credentials).withCommand((TuleapClientRawCmd.Command)new TuleapClientRawCmd.AllUserProjects(true)).configure().call()).forEach(project -> result.add(project.getShortname(), String.valueOf(project.getId())));
            }
            catch (IOException | IllegalArgumentException e) {
                result.clear();
            }
            return result;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillGitBaseUriItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("Tuleap Git", TuleapConfiguration.get().getGitBaseUrl());
            return result;
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            TuleapSCMSource.DescriptorImpl sourceDescriptor = (TuleapSCMSource.DescriptorImpl)Jenkins.get().getDescriptorByType(TuleapSCMSource.DescriptorImpl.class);
            ArrayList all = new ArrayList();
            all.addAll(SCMNavigatorTrait._for((SCMNavigatorDescriptor)this, TuleapSCMNavigatorContext.class, TuleapSCMSourceBuilder.class));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, TuleapSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, null, GitSCMBuilder.class));
            List distinct = all.stream().distinct().collect(Collectors.toList());
            ArrayList result = new ArrayList();
            NamedArrayList.select(distinct, (String)"Repositories", scmTraitDescriptor -> scmTraitDescriptor instanceof SCMNavigatorTraitDescriptor, (boolean)true, result);
            NamedArrayList.select(distinct, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select(distinct, (String)"Additional", null, (boolean)true, result);
            return result;
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-tuleap-scm-navigator icon-sm", "plugin/tuleap-git-branch-source/images/16x16/tuleap-scmnavigator.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-tuleap-scm-navigator icon-md", "plugin/tuleap-git-branch-source/images/24x24/tuleap-scmnavigator.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-tuleap-scm-navigator icon-lg", "plugin/tuleap-git-branch-source/images/32x32/tuleap-scmnavigator.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-tuleap-scm-navigator icon-xlg", "plugin/tuleap-git-branch-source/images/48x48/tuleap-scmnavigator.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-tuleap-logo icon-sm", "plugin/tuleap-git-branch-source/images/16x16/tuleap-logo.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-tuleap-logo icon-md", "plugin/tuleap-git-branch-source/images/24x24/tuleap-logo.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-tuleap-logo icon-lg", "plugin/tuleap-git-branch-source/images/32x32/tuleap-logo.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-tuleap-logo icon-xlg", "plugin/tuleap-git-branch-source/images/48x48/tuleap-logo.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-git-repo icon-sm", "plugin/tuleap-git-branch-source/images/16x16/git-repo.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-git-repo icon-md", "plugin/tuleap-git-branch-source/images/24x24/git-repo.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-git-repo icon-lg", "plugin/tuleap-git-branch-source/images/32x32/git-repo.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-git-repo icon-xlg", "plugin/tuleap-git-branch-source/images/48x48/git-repo.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-git-branch icon-sm", "plugin/tuleap-git-branch-source/images/16x16/git-branch.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-git-branch icon-md", "plugin/tuleap-git-branch-source/images/24x24/git-branch.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-git-branch icon-lg", "plugin/tuleap-git-branch-source/images/32x32/git-branch.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-git-branch icon-xlg", "plugin/tuleap-git-branch-source/images/48x48/git-branch.png", "width: 48px; height: 48px;"));
        }
    }
}

