/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.git.GitSCM;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapBrowser;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapPullRequestRevision;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapPullRequestSCMHead;
import org.jetbrains.annotations.NotNull;

public class TuleapSCMBuilder
extends GitSCMBuilder<TuleapSCMBuilder> {
    private String repositoryBaseUrl;

    public TuleapSCMBuilder(@NotNull SCMHead head, SCMRevision revision, @NotNull String remote, String credentialsId, String repositoryBaseUrl) {
        super(head, revision, remote, credentialsId);
        this.withoutRefSpecs();
        if (head instanceof TuleapPullRequestSCMHead) {
            TuleapPullRequestSCMHead tuleapPullRequestSCMHead = (TuleapPullRequestSCMHead)head;
            this.withRefSpec("+" + tuleapPullRequestSCMHead.getHeadReference() + ":refs/remotes/@{remote}/TLP-PR-" + tuleapPullRequestSCMHead.getId());
        } else {
            this.withRefSpec("+refs/heads/" + head.getName() + ":refs/remotes/@{remote}/" + head.getName());
        }
        this.repositoryBaseUrl = repositoryBaseUrl;
        this.withBrowser(new TuleapBrowser(repositoryBaseUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GitSCM build() {
        SCMHead head = this.head();
        SCMRevision revision = this.revision();
        try {
            if (head instanceof TuleapPullRequestSCMHead && revision instanceof TuleapPullRequestRevision) {
                this.withRevision(((TuleapPullRequestRevision)revision).getOrigin());
            }
            GitSCM gitSCM = super.build();
            return gitSCM;
        }
        finally {
            this.withHead(head);
            this.withRevision(revision);
            this.withBrowser(new TuleapBrowser(this.repositoryBaseUrl));
        }
    }
}

