/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.WorkspaceDependentMacro;

@Extension
public class JsonFileMacro
extends WorkspaceDependentMacro {
    public static final Logger LOGGER = Logger.getLogger(JsonFileMacro.class.getName());
    private static final String MACRO_NAME = "JSON";
    @DataBoundTokenMacro.Parameter(required=true)
    public String file = null;
    @DataBoundTokenMacro.Parameter
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Retain API compatibility.")
    public String path = null;
    @DataBoundTokenMacro.Parameter
    public String expr = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public Callable<String, IOException> getCallable(Run<?, ?> run, String root, TaskListener listener) {
        if (this.path != null && this.expr != null) {
            this.path = null;
        }
        return new ReadJSON(root, this.file, this.path, this.expr, run.getCharset());
    }

    private static class ReadJSON
    extends MasterToSlaveCallable<String, IOException> {
        private String root;
        private String filename;
        private String expr;
        private String path;
        private Charset charset;

        public ReadJSON(String root, String filename, String path, String expr, Charset charset) {
            this.root = root;
            this.filename = filename;
            this.path = path;
            this.charset = charset;
            this.expr = expr;
        }

        public String extractWithPath(File file) {
            String result = "";
            try {
                JSONObject obj = JSONObject.fromObject((Object)FileUtils.readFileToString((File)file, (Charset)this.charset));
                String[] pathKeys = this.path.split("\\.");
                int count = 0;
                for (String key : pathKeys) {
                    Object obj2;
                    if (obj.containsKey((Object)key)) {
                        ++count;
                        obj2 = obj.get(key);
                        if (!(obj2 instanceof JSONObject)) {
                            result = count < pathKeys.length ? "Error: Found primitive type at key '".concat(key).concat("' before exhausting path") : obj2.toString();
                            break;
                        }
                    } else {
                        result = "Error: The key '".concat(key).concat("' does not exist in the JSON");
                        break;
                    }
                    obj = (JSONObject)obj2;
                }
            }
            catch (IOException e) {
                result = "Error: ".concat(this.filename).concat(" - Could not read JSON file.");
            }
            catch (JSONException e) {
                result = "Error: ".concat(this.filename).concat(" - JSON not well formed.");
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Unhandled exception during the macro evaluation", e);
                result = "Error: ".concat(this.filename).concat(" - '").concat(this.path).concat("' invalid syntax or path maybe?");
            }
            return result;
        }

        public String extractWithJsonPath(File file) {
            String result;
            try {
                DocumentContext jsonContext = JsonPath.parse((File)file);
                result = (String)jsonContext.read(this.expr, new Predicate[0]);
            }
            catch (IOException e) {
                result = "Error: ".concat(this.filename).concat(" - Could not read JSON file");
            }
            return result;
        }

        public String call() throws IOException {
            if (this.path == null && this.expr == null) {
                return "You must specify the path or expr parameter";
            }
            File file = new File(this.root, this.filename);
            String result = "";
            if (file.exists()) {
                if (this.path != null) {
                    result = this.extractWithPath(file);
                } else if (this.expr != null) {
                    result = this.extractWithJsonPath(file);
                }
            } else {
                result = "Error: ".concat(this.filename).concat(" not found");
            }
            return result;
        }
    }
}

