/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class BuildLogExcerptMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_LOG_EXCERPT";
    @DataBoundTokenMacro.Parameter(required=true)
    public String start;
    @DataBoundTokenMacro.Parameter(required=true)
    public String end;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, null, listener, macroName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String string;
        BufferedReader reader = new BufferedReader(run.getLogReader());
        try {
            string = this.getContent(reader);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((Reader)reader);
                throw throwable;
            }
            catch (IOException e) {
                listener.getLogger().println("Error getting BUILD_LOG_EXCERPT - " + e.getMessage());
                return "";
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    String getContent(BufferedReader reader) throws IOException {
        String line;
        Pattern startPattern = Pattern.compile(this.start);
        Pattern endPattern = Pattern.compile(this.end);
        StringBuilder buffer = new StringBuilder();
        boolean started = false;
        while ((line = reader.readLine()) != null) {
            if (startPattern.matcher(line = ConsoleNote.removeNotes((String)line)).matches()) {
                started = true;
                continue;
            }
            if (!started) continue;
            if (endPattern.matcher(line).matches()) break;
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }
}

