/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.tokenmacro.Util;
import org.jenkinsci.plugins.tokenmacro.impl.ChangesSinceLastBuildMacro;

public abstract class AbstractChangesSinceMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public boolean reverse = false;
    @DataBoundTokenMacro.Parameter
    public String format;
    @DataBoundTokenMacro.Parameter
    public boolean showPaths = false;
    @DataBoundTokenMacro.Parameter
    public String changesFormat;
    @DataBoundTokenMacro.Parameter
    public String pathFormat = "\\t%p\\n";
    @DataBoundTokenMacro.Parameter
    public boolean showDependencies = false;
    @DataBoundTokenMacro.Parameter
    public String dateFormat;
    @DataBoundTokenMacro.Parameter
    public String regex;
    @DataBoundTokenMacro.Parameter
    public String replace;
    @DataBoundTokenMacro.Parameter(alias="default")
    public String def = "No changes\n";

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, null, listener, macroName);
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        Run<?, ?> endRun;
        Run startRun;
        if (TokenMacro.getPreviousRun(run, listener) == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)this.format)) {
            this.format = this.getDefaultFormatValue();
        }
        this.format = TokenMacro.expandAll(run, workspace, listener, this.format);
        if (StringUtils.isNotEmpty((String)this.pathFormat)) {
            this.pathFormat = TokenMacro.expandAll(run, workspace, listener, this.pathFormat);
        }
        StringBuffer sb = new StringBuffer();
        if (this.reverse) {
            startRun = run;
            endRun = this.getFirstIncludedRun(run, listener);
        } else {
            startRun = this.getFirstIncludedRun(run, listener);
            endRun = run;
        }
        Run currentBuild = null;
        while (currentBuild != endRun) {
            currentBuild = currentBuild == null ? startRun : (this.reverse ? currentBuild.getPreviousBuild() : currentBuild.getNextBuild());
            this.appendBuild(sb, listener, currentBuild);
        }
        return sb.toString();
    }

    private void appendBuild(StringBuffer buf, final TaskListener listener, final Run<?, ?> currentRun) throws MacroEvaluationException {
        final ChangesSinceLastBuildMacro changes = new ChangesSinceLastBuildMacro(this.changesFormat, this.pathFormat, this.showPaths);
        changes.showDependencies = this.showDependencies;
        changes.dateFormat = this.dateFormat;
        changes.regex = this.regex;
        changes.replace = this.replace;
        changes.def = this.def;
        Util.printf(buf, this.format, new Util.PrintfSpec(){

            @Override
            public boolean printSpec(StringBuffer buf, char formatChar) {
                switch (formatChar) {
                    case 'c': {
                        try {
                            buf.append(changes.evaluate(currentRun, null, listener, "CHANGES_SINCE_LAST_BUILD"));
                        }
                        catch (MacroEvaluationException macroEvaluationException) {
                        }
                        catch (IOException iOException) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return true;
                    }
                    case 'n': {
                        buf.append(currentRun.getNumber());
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public abstract String getDefaultFormatValue();

    public abstract String getShortHelpDescription();

    public abstract Run<?, ?> getFirstIncludedRun(Run<?, ?> var1, TaskListener var2);
}

