/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.tokenmacro.Transform;
import org.jenkinsci.plugins.tokenmacro.transform.BeginningOrEndMatchTransorm;
import org.jenkinsci.plugins.tokenmacro.transform.ContentLengthTransform;
import org.jenkinsci.plugins.tokenmacro.transform.SubstringTransform;
import org.parboiled.Action;
import org.parboiled.BaseParser;
import org.parboiled.Context;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.Var;

public class Parser
extends BaseParser<Object> {
    private Stack<Transform> transforms = new Stack();
    private StringBuffer output;
    private Run<?, ?> run;
    private FilePath workspace;
    private TaskListener listener;
    private boolean throwException;
    private List<TokenMacro> privateTokens;
    private String stringWithMacro;
    private String tokenName;
    private ListMultimap<String, String> args;

    public Parser(Run<?, ?> run, FilePath workspace, TaskListener listener, String stringWithMacro) {
        this.run = run;
        this.workspace = workspace;
        this.listener = listener;
        this.stringWithMacro = stringWithMacro;
        this.output = new StringBuffer();
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public void setPrivateTokens(List<TokenMacro> privateTokens) {
        this.privateTokens = privateTokens;
    }

    public static String process(AbstractBuild<?, ?> build, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException {
        return Parser.process(build, build.getWorkspace(), listener, stringWithMacro, throwException, privateTokens);
    }

    public static String process(Run<?, ?> run, FilePath workspace, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException {
        if (StringUtils.isBlank((String)stringWithMacro)) {
            return stringWithMacro;
        }
        Parser p = (Parser)Parboiled.createParser(Parser.class, (Object[])new Object[]{run, workspace, listener, stringWithMacro});
        p.setThrowException(throwException);
        p.setPrivateTokens(privateTokens);
        try {
            new ReportingParseRunner(p.Text()).run(stringWithMacro);
        }
        catch (Exception e) {
            if (e.getCause() instanceof MacroEvaluationException) {
                throw (MacroEvaluationException)e.getCause();
            }
            return String.format("Error processing tokens: %s", e.getMessage());
        }
        return p.output.toString();
    }

    public Rule Text() throws InterruptedException, MacroEvaluationException, IOException {
        return this.Sequence(this.ZeroOrMore(this.FirstOf(this.Token(), this.Sequence(ANY, this.appendOutput(), new Object[0]), new Object[0])), EOI, new Object[0]);
    }

    public Rule Token() throws InterruptedException, MacroEvaluationException, IOException {
        return this.FirstOf(this.EscapedToken(), this.DelimitedToken(), new Object[]{this.NonDelimitedToken()});
    }

    Rule DelimitedToken() throws InterruptedException, MacroEvaluationException, IOException {
        return this.Sequence(Character.valueOf('$'), Character.valueOf('{'), new Object[]{this.Optional(this.Sequence(Character.valueOf('#'), this.addTransform(new ContentLengthTransform()), new Object[0])), this.Sequence(this.Identifier(), this.startToken(), new Object[0]), this.Optional(this.Expansion()), this.Optional(this.Arguments()), this.Optional(this.Spacing()), Character.valueOf('}'), this.processToken()});
    }

    Rule WhiteSpace() {
        return this.ZeroOrMore(this.AnyOf(" \t\f"));
    }

    Rule EscapedToken() {
        return this.FirstOf(this.EscapedDelimitedToken(), this.EscapedNonDelimitedToken(), new Object[0]);
    }

    Rule EscapedDelimitedToken() {
        return this.Sequence(Character.valueOf('$'), this.Sequence(Character.valueOf('$'), Character.valueOf('{'), new Object[]{this.Identifier(), this.ZeroOrMore(this.TestNot(Character.valueOf('}'))), Character.valueOf('}')}), new Object[]{this.appendOutput()});
    }

    Rule EscapedNonDelimitedToken() {
        return this.Sequence(Character.valueOf('$'), this.Sequence(Character.valueOf('$'), this.Identifier(), new Object[0]), new Object[]{this.appendOutput()});
    }

    Rule NonDelimitedToken() throws InterruptedException, MacroEvaluationException, IOException {
        return this.Sequence(Character.valueOf('$'), this.Sequence(this.Identifier(), this.startToken(), new Object[0]), new Object[]{this.processToken()});
    }

    Rule Expansion() {
        return this.FirstOf(this.SubstringExpansion(), this.BeginningMatchExpansion(), new Object[]{this.EndingMatchExpansion()});
    }

    Rule SubstringExpansion() {
        final Var offset = new Var((Object)0);
        final Var length = new Var((Object)Integer.MAX_VALUE);
        final Var isOffsetNegative = new Var((Object)false);
        final Var isLengthNegative = new Var((Object)false);
        return this.Sequence(Character.valueOf(':'), this.Sequence(this.Optional(Character.valueOf(' '), Character.valueOf('-'), new Object[]{isOffsetNegative.set((Object)true)}), this.IntegerValue(), new Object[]{offset.set((Object)Integer.parseInt(((String)this.pop()).trim()))}), new Object[]{this.Optional(Character.valueOf(':'), this.Sequence(this.Optional(Character.valueOf('-'), isLengthNegative.set((Object)true), new Object[0]), this.IntegerValue(), new Object[]{length.set((Object)Integer.parseInt(((String)this.pop()).trim()))}), new Object[0]), new Action(){

            public boolean run(Context context) {
                return Parser.this.addTransform(new SubstringTransform(((Boolean)isOffsetNegative.get() != false ? -1 : 1) * (Integer)offset.get(), ((Boolean)isLengthNegative.get() != false ? -1 : 1) * (Integer)length.get()));
            }
        }});
    }

    Rule BeginningMatchExpansion() {
        return this.Sequence(Character.valueOf('#'), this.ZeroOrMore(this.FirstOf(this.NoneOf("\\\"\r\n},"), this.Sequence(Character.valueOf('\\'), this.FirstOf(this.Sequence(this.Optional(Character.valueOf('\r')), Character.valueOf('\n'), new Object[0]), ANY, new Object[0]), new Object[0]), new Object[0])), new Object[]{this.addTransform(new BeginningOrEndMatchTransorm(this.match(), true))});
    }

    Rule EndingMatchExpansion() {
        return this.Sequence(Character.valueOf('%'), this.ZeroOrMore(this.FirstOf(this.NoneOf("\\\"\r\n},"), this.Sequence(Character.valueOf('\\'), this.FirstOf(this.Sequence(this.Optional(Character.valueOf('\r')), Character.valueOf('\n'), new Object[0]), ANY, new Object[0]), new Object[0]), new Object[0])), new Object[]{this.addTransform(new BeginningOrEndMatchTransorm(this.match(), false))});
    }

    Rule Arguments() {
        return this.ZeroOrMore(this.Sequence(this.Spacing(), Character.valueOf(','), new Object[]{this.Spacing(), this.Sequence(this.Identifier(), this.push(this.match()), new Object[0]), this.Spacing(), Character.valueOf('='), this.Spacing(), this.ArgumentValue()}), this.addArg(), new Object[0]);
    }

    Rule Spacing() {
        return this.ZeroOrMore(this.AnyOf(" \t"));
    }

    Rule ArgumentValue() {
        return this.FirstOf(this.FloatValue(), this.IntegerValue(), new Object[]{this.StringValue(), this.BooleanValue()});
    }

    Rule IntegerValue() {
        return this.Sequence(this.FirstOf(this.HexNumeral(), this.OctalNumeral(), new Object[]{this.DecimalNumeral()}), this.push(this.match()), new Object[0]);
    }

    Rule HexNumeral() {
        return this.Sequence(Character.valueOf('0'), this.IgnoreCase('x'), new Object[]{this.OneOrMore(this.HexDigit())});
    }

    Rule OctalNumeral() {
        return this.Sequence(Character.valueOf('0'), this.OneOrMore(this.CharRange('0', '7')), new Object[0]);
    }

    Rule DecimalNumeral() {
        return this.FirstOf(Character.valueOf('0'), this.Sequence(this.CharRange('1', '9'), this.ZeroOrMore(this.Digit()), new Object[0]), new Object[0]);
    }

    Rule DecimalFloat() {
        return this.FirstOf(this.Sequence(this.OneOrMore(this.Digit()), Character.valueOf('.'), new Object[]{this.ZeroOrMore(this.Digit()), this.Optional(this.Exponent())}), this.Sequence(Character.valueOf('.'), this.OneOrMore(this.Digit()), new Object[]{this.Optional(this.Exponent())}), new Object[]{this.Sequence(this.OneOrMore(this.Digit()), this.Exponent(), new Object[0]), this.Sequence(this.OneOrMore(this.Digit()), this.Optional(this.Exponent()), new Object[0])});
    }

    Rule Exponent() {
        return this.Sequence(this.AnyOf("eE"), this.Optional(this.AnyOf("+-")), new Object[]{this.OneOrMore(this.Digit())});
    }

    Rule Digit() {
        return this.CharRange('0', '9');
    }

    @SuppressSubnodes
    Rule HexFloat() {
        return this.Sequence(this.HexSignificant(), this.BinaryExponent(), new Object[0]);
    }

    Rule HexSignificant() {
        return this.FirstOf(this.Sequence(this.FirstOf("0x", "0X", new Object[0]), this.ZeroOrMore(this.HexDigit()), new Object[]{Character.valueOf('.'), this.OneOrMore(this.HexDigit())}), this.Sequence(this.HexNumeral(), this.Optional(Character.valueOf('.')), new Object[0]), new Object[0]);
    }

    Rule BinaryExponent() {
        return this.Sequence(this.AnyOf("pP"), this.Optional(this.AnyOf("+-")), new Object[]{this.OneOrMore(this.Digit())});
    }

    Rule StringValue() {
        return this.Sequence(Character.valueOf('\"'), this.ZeroOrMore(this.FirstOf(this.NoneOf("\\\"\r\n"), this.Sequence(Character.valueOf('\\'), this.FirstOf(this.Sequence(this.Optional(Character.valueOf('\r')), Character.valueOf('\n'), new Object[0]), ANY, new Object[0]), new Object[0]), new Object[0])), new Object[]{this.push(Parser.unescapeString(this.match())), Character.valueOf('\"')});
    }

    Rule HexDigit() {
        return this.FirstOf(this.CharRange('a', 'f'), this.CharRange('A', 'F'), new Object[]{this.CharRange('0', '9')});
    }

    Rule BooleanValue() {
        return this.Sequence(this.FirstOf(this.String("true"), this.String("false"), new Object[0]), this.push(this.match()), new Object[0]);
    }

    Rule FloatValue() {
        return this.Sequence(this.FirstOf(this.HexFloat(), this.DecimalFloat(), new Object[0]), this.push(this.match()), new Object[0]);
    }

    Rule Identifier() {
        return this.Sequence(this.Letter(), this.ZeroOrMore(this.LetterOrDigit()), new Object[0]);
    }

    Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_')});
    }

    Rule LetterOrDigit() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.CharRange('0', '9'), Character.valueOf('_')});
    }

    boolean addTransform(Transform t) {
        this.transforms.push(t);
        return true;
    }

    boolean processToken() throws IOException, InterruptedException, MacroEvaluationException {
        String replacement = null;
        ArrayList<TokenMacro> all = new ArrayList<TokenMacro>((Collection<TokenMacro>)TokenMacro.all());
        if (this.privateTokens != null) {
            for (TokenMacro tokenMacro : this.privateTokens) {
                if (tokenMacro == null) continue;
                all.add(tokenMacro);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry e : this.args.entries()) {
            map.put((String)e.getKey(), (String)e.getValue());
        }
        for (TokenMacro tm : all) {
            if (!tm.acceptsMacroName(this.tokenName)) continue;
            try {
                if (this.run instanceof AbstractBuild) {
                    AbstractBuild build = (AbstractBuild)this.run;
                    replacement = tm.evaluate(build, this.listener, this.tokenName, map, this.args);
                } else {
                    replacement = tm.evaluate(this.run, this.workspace, this.listener, this.tokenName, map, this.args);
                }
                if (!tm.hasNestedContent()) break;
                replacement = Parser.process(this.run, this.workspace, this.listener, replacement, this.throwException, this.privateTokens);
            }
            catch (MacroEvaluationException e) {
                if (this.throwException) {
                    throw e;
                }
                replacement = String.format("[Error replacing '%s' - %s]", this.tokenName, e.getMessage());
            }
            break;
        }
        if (replacement == null && this.throwException) {
            throw new MacroEvaluationException(String.format("Unrecognized macro '%s' in '%s'", this.tokenName, this.stringWithMacro));
        }
        if (replacement == null && !this.throwException) {
            this.output.append(this.getContext().getInputBuffer().extract(this.getContext().getStartIndex(), this.getContext().getCurrentIndex()));
        } else if (replacement != null) {
            while (this.transforms != null && this.transforms.size() > 0) {
                Transform transform = this.transforms.pop();
                replacement = transform.transform(replacement);
            }
            this.output.append(replacement);
        }
        this.tokenName = "";
        this.args = null;
        return true;
    }

    boolean appendOutput() {
        this.output.append(this.match());
        return true;
    }

    boolean startToken() {
        this.tokenName = this.match();
        if (this.args == null) {
            this.args = Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<String>>(){

                public List<String> get() {
                    return new ArrayList<String>();
                }
            });
        } else {
            this.args.clear();
        }
        return true;
    }

    boolean addArg() {
        String value = (String)this.pop();
        String name = (String)this.pop();
        this.args.put((Object)name, (Object)value);
        return true;
    }

    public static String unescapeString(String escapedString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < escapedString.length(); ++i) {
            char c = escapedString.charAt(i);
            if (c == '\\') {
                sb.append(Parser.unescapeChar(escapedString.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char unescapeChar(char escapedChar) {
        switch (escapedChar) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
        }
        return escapedChar;
    }
}

