/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class BuildLogMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_LOG";
    public static final int MAX_LINES_DEFAULT_VALUE = 250;
    @DataBoundTokenMacro.Parameter
    public int maxLines = 250;
    @DataBoundTokenMacro.Parameter
    public int truncTailLines = 0;
    @DataBoundTokenMacro.Parameter
    public boolean escapeHtml = false;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, null, listener, macroName);
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        if (this.maxLines <= 0) {
            throw new MacroEvaluationException("Invalid maxLines value: " + this.maxLines);
        }
        if (this.truncTailLines < 0) {
            throw new MacroEvaluationException("Invalid truncTailLines value: " + this.truncTailLines);
        }
        StringBuilder buffer = new StringBuilder();
        try {
            List lines = run.getLog(this.maxLines);
            int nLinesToEval = lines.size() - this.truncTailLines;
            for (int i = 0; i < nLinesToEval; ++i) {
                String line = (String)lines.get(i);
                if (this.escapeHtml) {
                    line = StringEscapeUtils.escapeHtml((String)line);
                }
                buffer.append(line);
                buffer.append('\n');
            }
        }
        catch (IOException e) {
            listener.getLogger().append("Error getting build log data: " + e.getMessage());
        }
        return buffer.toString();
    }
}

