/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class JsonFileMacro
extends DataBoundTokenMacro {
    public static final Logger LOGGER = Logger.getLogger(JsonFileMacro.class.getName());
    private static final String MACRO_NAME = "JSON";
    @DataBoundTokenMacro.Parameter(required=true)
    public String file = null;
    @DataBoundTokenMacro.Parameter(required=true)
    public String path = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, JsonFileMacro.getWorkspace(context), listener, macroName);
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String root = workspace.getRemote();
        return (String)workspace.act((Callable)new ReadJSON(root, this.file, this.path, run.getCharset()));
    }

    private static class ReadJSON
    extends MasterToSlaveCallable<String, IOException> {
        private String root;
        private String filename;
        private String pathexpression;
        private Charset charset;

        public ReadJSON(String root, String filename, String path, Charset charset) {
            this.root = root;
            this.filename = filename;
            this.pathexpression = path;
            this.charset = charset;
        }

        public String call() throws IOException {
            File file = new File(this.root, this.filename);
            String result = "";
            if (file.exists()) {
                try {
                    JSONObject obj = JSONObject.fromObject((Object)FileUtils.readFileToString((File)file, (Charset)this.charset));
                    String[] pathKeys = this.pathexpression.split("\\.");
                    int count = 0;
                    for (String key : pathKeys) {
                        Object obj2;
                        if (obj.containsKey((Object)key)) {
                            ++count;
                            obj2 = obj.get(key);
                            if (!(obj2 instanceof JSONObject)) {
                                if (count < pathKeys.length) {
                                    result = "Error: Found primitive type at key '".concat(key).concat("' before exhausting path");
                                }
                                result = obj2.toString();
                            }
                        } else {
                            result = "Error: The key '".concat(key).concat("' does not exist in the JSON");
                        }
                        obj = (JSONObject)obj2;
                    }
                }
                catch (IOException e) {
                    result = "Error: ".concat(this.filename).concat(" - Could not read JSON file.");
                }
                catch (JSONException e) {
                    result = "Error: ".concat(this.filename).concat(" - JSON not well formed.");
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Unhandled exception during the macro evaluation", e);
                    result = "Error: ".concat(this.filename).concat(" - '").concat(this.pathexpression).concat("' invalid syntax or path maybe?");
                }
            } else {
                result = "Error: ".concat(this.filename).concat(" not found");
            }
            return result;
        }
    }
}

