/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public final class LogRegExMacro
extends DataBoundTokenMacro {
    private static final String MACRO_NAME = "LOG_REGEX";
    @DataBoundTokenMacro.Parameter(required=true)
    public String regex = null;
    @DataBoundTokenMacro.Parameter(required=true)
    public String replacement = null;
    @DataBoundTokenMacro.Parameter(required=false)
    public String charset = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return MACRO_NAME.equals(macroName);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.readLogFile(context.getLogFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLogFile(File file) throws IOException {
        if (this.regex == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(this.regex);
        Charset logCharset = Charset.defaultCharset();
        if (this.charset != null) {
            try {
                logCharset = Charset.forName(this.charset);
            }
            catch (IllegalCharsetNameException ex) {
                throw new IOException("Charset " + this.charset + " is illegal", ex);
            }
            catch (UnsupportedCharsetException ex) {
                throw new IOException("Charset " + this.charset + " is not supported", ex);
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), logCharset));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String string = this.getTranslatedDescription(matcher);
                return string;
            }
        }
        finally {
            reader.close();
        }
        return "";
    }

    private String getTranslatedDescription(Matcher matcher) {
        String result = this.replacement;
        if (result == null) {
            result = matcher.groupCount() == 0 ? "\\0" : "\\1";
        }
        for (int i = matcher.groupCount(); i >= 0; --i) {
            result = result.replace("\\" + i, matcher.group(i) == null ? "" : matcher.group(i));
        }
        return result;
    }
}

