/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

@Extension
public class BuildStatusMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_STATUS";

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        if (build.isBuilding() && null == build.getResult()) {
            return "Building";
        }
        Result buildResult = build.getResult();
        if (buildResult == Result.FAILURE) {
            Run<?, ?> prevBuild = TokenMacro.getPreviousRun(build, listener);
            if (prevBuild == null || prevBuild.getResult() != Result.FAILURE) return "Failure";
            return "Still Failing";
        }
        if (buildResult == Result.UNSTABLE) {
            Run<?, ?> prevRun = TokenMacro.getPreviousRun(build, listener);
            if (prevRun == null) return "Unstable";
            if (prevRun.getResult() == Result.UNSTABLE) {
                return "Still Unstable";
            }
            if (prevRun.getResult() == Result.SUCCESS) {
                return "Unstable";
            }
            if (prevRun.getResult() != Result.FAILURE && prevRun.getResult() != Result.ABORTED && prevRun.getResult() != Result.NOT_BUILT) return "Unknown";
            Run<?, ?> previous = TokenMacro.getPreviousRun(prevRun, listener);
            while (previous != null) {
                if (previous.getResult() == Result.SUCCESS) {
                    return "Unstable";
                }
                if (previous.getResult() == Result.UNSTABLE) {
                    return "Still unstable";
                }
                previous = TokenMacro.getPreviousRun(previous, listener);
            }
            return "Unstable";
        }
        if (buildResult == Result.SUCCESS) {
            Run<?, ?> prevBuild = TokenMacro.getPreviousRun(build, listener);
            if (prevBuild == null || prevBuild.getResult() != Result.UNSTABLE && prevBuild.getResult() != Result.FAILURE) return "Successful";
            return "Fixed";
        }
        if (buildResult == Result.NOT_BUILT) {
            return "Not Built";
        }
        if (buildResult != Result.ABORTED) return "Unknown";
        return "Aborted";
    }
}

