/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class BuildLogRegexMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_LOG_REGEX";
    private static final int LINES_BEFORE_DEFAULT_VALUE = 0;
    private static final int LINES_AFTER_DEFAULT_VALUE = 0;
    private static final int MAX_MATCHES_DEFAULT_VALUE = 0;
    @DataBoundTokenMacro.Parameter
    public String regex = "(?i)\\b(error|exception|fatal|fail(ed|ure)|un(defined|resolved))\\b";
    @DataBoundTokenMacro.Parameter
    public int linesBefore = 0;
    @DataBoundTokenMacro.Parameter
    public int linesAfter = 0;
    @DataBoundTokenMacro.Parameter
    public int maxMatches = 0;
    @DataBoundTokenMacro.Parameter
    public boolean showTruncatedLines = true;
    @DataBoundTokenMacro.Parameter
    public String substText = null;
    @DataBoundTokenMacro.Parameter
    public boolean escapeHtml = false;
    @DataBoundTokenMacro.Parameter
    public String matchedLineHtmlStyle = null;
    @DataBoundTokenMacro.Parameter
    public boolean addNewline = true;
    @DataBoundTokenMacro.Parameter
    public String defaultValue = "";

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    private boolean startPre(StringBuffer buffer, boolean insidePre) {
        if (!insidePre) {
            buffer.append("<pre>\n");
            insidePre = true;
        }
        return insidePre;
    }

    private boolean stopPre(StringBuffer buffer, boolean insidePre) {
        if (insidePre) {
            buffer.append("</pre>\n");
            insidePre = false;
        }
        return insidePre;
    }

    private void appendContextLine(StringBuffer buffer, String line, boolean escapeHtml) {
        if (escapeHtml) {
            line = StringEscapeUtils.escapeHtml((String)line);
        }
        buffer.append(line);
        buffer.append('\n');
    }

    private void appendMatchedLine(StringBuffer buffer, String line, boolean escapeHtml, String style, boolean addNewline) {
        if (escapeHtml) {
            line = StringEscapeUtils.escapeHtml((String)line);
        }
        if (style != null) {
            buffer.append("<b");
            if (style.length() > 0) {
                buffer.append(" style=\"");
                buffer.append(style);
                buffer.append("\"");
            }
            buffer.append(">");
        }
        buffer.append(line);
        if (style != null) {
            buffer.append("</b>");
        }
        if (addNewline) {
            buffer.append('\n');
        }
    }

    private void appendLinesTruncated(StringBuffer buffer, int numLinesTruncated, boolean asHtml) {
        if (asHtml) {
            buffer.append("<p>");
        }
        buffer.append("[...truncated ");
        buffer.append(numLinesTruncated);
        buffer.append(" lines...]");
        if (asHtml) {
            buffer.append("</p>");
        }
        buffer.append('\n');
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        try {
            BufferedReader reader = new BufferedReader(build.getLogReader());
            String transformedContent = this.getContent(reader);
            reader.close();
            return transformedContent;
        }
        catch (IOException ex) {
            listener.error(ex.getMessage());
            return "";
        }
    }

    String getContent(BufferedReader reader) throws IOException {
        String line;
        boolean asHtml = this.matchedLineHtmlStyle != null;
        this.escapeHtml = asHtml || this.escapeHtml;
        Pattern pattern = Pattern.compile(this.regex);
        StringBuffer buffer = new StringBuffer();
        int numLinesTruncated = 0;
        int numMatches = 0;
        int numLinesStillNeeded = 0;
        boolean insidePre = false;
        LinkedList<String> linesBeforeList = new LinkedList<String>();
        while ((line = reader.readLine()) != null) {
            line = ConsoleNote.removeNotes((String)line);
            while (linesBeforeList.size() > this.linesBefore) {
                linesBeforeList.remove();
                ++numLinesTruncated;
            }
            Matcher matcher = pattern.matcher(line);
            StringBuffer sb = new StringBuffer();
            boolean matched = false;
            while (matcher.find()) {
                matched = true;
                if (this.substText == null) break;
                matcher.appendReplacement(sb, this.substText);
            }
            if (matched) {
                if (this.showTruncatedLines && numLinesTruncated > 0) {
                    insidePre = this.stopPre(buffer, insidePre);
                    this.appendLinesTruncated(buffer, numLinesTruncated, asHtml);
                    numLinesTruncated = 0;
                }
                if (asHtml) {
                    insidePre = this.startPre(buffer, insidePre);
                }
                while (!linesBeforeList.isEmpty()) {
                    this.appendContextLine(buffer, (String)linesBeforeList.remove(), this.escapeHtml);
                }
                if (this.substText != null) {
                    matcher.appendTail(sb);
                    line = sb.toString();
                }
                this.appendMatchedLine(buffer, line, this.escapeHtml, this.matchedLineHtmlStyle, this.addNewline);
                ++numMatches;
                numLinesStillNeeded = this.linesAfter;
            } else if (numLinesStillNeeded > 0) {
                this.appendContextLine(buffer, line, this.escapeHtml);
                --numLinesStillNeeded;
            } else {
                linesBeforeList.offer(line);
            }
            if (this.maxMatches == 0 || numMatches < this.maxMatches || numLinesStillNeeded != 0) continue;
            break;
        }
        if (this.showTruncatedLines) {
            while (linesBeforeList.size() > 0) {
                linesBeforeList.remove();
                ++numLinesTruncated;
            }
            if (line != null) {
                while ((line = reader.readLine()) != null) {
                    ++numLinesTruncated;
                }
            }
            if (numLinesTruncated > 0) {
                insidePre = this.stopPre(buffer, insidePre);
                this.appendLinesTruncated(buffer, numLinesTruncated, asHtml);
            }
        }
        insidePre = this.stopPre(buffer, insidePre);
        if (buffer.length() == 0) {
            return this.defaultValue;
        }
        return buffer.toString();
    }
}

