/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.tokenmacro.Util;
import org.jenkinsci.plugins.tokenmacro.impl.ChangesSinceLastBuildMacro;

public abstract class AbstractChangesSinceMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public boolean reverse = false;
    @DataBoundTokenMacro.Parameter
    public String format;
    @DataBoundTokenMacro.Parameter
    public boolean showPaths = false;
    @DataBoundTokenMacro.Parameter
    public String changesFormat;
    @DataBoundTokenMacro.Parameter
    public String pathFormat = "\\t%p\\n";
    @DataBoundTokenMacro.Parameter
    public boolean showDependencies = false;
    @DataBoundTokenMacro.Parameter
    public String dateFormat;
    @DataBoundTokenMacro.Parameter
    public String regex;
    @DataBoundTokenMacro.Parameter
    public String replace;
    @DataBoundTokenMacro.Parameter(alias="default")
    public String def = "No changes\n";

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        Run<?, ?> endBuild;
        Run startBuild;
        if (TokenMacro.getPreviousRun(build, listener) == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)this.format)) {
            this.format = this.getDefaultFormatValue();
        }
        StringBuffer sb = new StringBuffer();
        if (this.reverse) {
            startBuild = build;
            endBuild = this.getFirstIncludedRun(build, listener);
        } else {
            startBuild = this.getFirstIncludedRun(build, listener);
            endBuild = build;
        }
        Run currentBuild = null;
        while (currentBuild != endBuild) {
            currentBuild = currentBuild == null ? startBuild : (this.reverse ? currentBuild.getPreviousBuild() : currentBuild.getNextBuild());
            this.appendBuild(sb, listener, currentBuild);
        }
        return sb.toString();
    }

    private void appendBuild(StringBuffer buf, final TaskListener listener, final Run<?, ?> currentRun) throws MacroEvaluationException {
        final ChangesSinceLastBuildMacro changes = new ChangesSinceLastBuildMacro(this.changesFormat, this.pathFormat, this.showPaths);
        changes.showDependencies = this.showDependencies;
        changes.dateFormat = this.dateFormat;
        changes.regex = this.regex;
        changes.replace = this.replace;
        changes.def = this.def;
        Util.printf(buf, this.format, new Util.PrintfSpec(){

            @Override
            public boolean printSpec(StringBuffer buf, char formatChar) {
                switch (formatChar) {
                    case 'c': {
                        if (currentRun instanceof AbstractBuild) {
                            try {
                                buf.append(changes.evaluate((AbstractBuild)currentRun, listener, "CHANGES_SINCE_LAST_BUILD"));
                            }
                            catch (MacroEvaluationException macroEvaluationException) {
                            }
                            catch (IOException iOException) {
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        return true;
                    }
                    case 'n': {
                        buf.append(currentRun.getNumber());
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public boolean hasNestedContent() {
        return true;
    }

    public abstract String getDefaultFormatValue();

    public abstract String getShortHelpDescription();

    public abstract Run<?, ?> getFirstIncludedRun(Run<?, ?> var1, TaskListener var2);
}

