/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class XmlFileMacro
extends DataBoundTokenMacro {
    public static final Logger LOGGER = Logger.getLogger(XmlFileMacro.class.getName());
    @DataBoundTokenMacro.Parameter(required=true)
    public String file = null;
    @DataBoundTokenMacro.Parameter(required=true)
    public String xpath = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("XML");
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        FilePath workspace = this.getWorkspace(context, macroName);
        String root = workspace.getRemote();
        return (String)workspace.act((Callable)new ReadXML(root, this.file, this.xpath));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadXML
    implements Callable<String, IOException> {
        private String root;
        private String filename;
        private String xpathexpression;

        public ReadXML(String root, String filename, String xpath) {
            this.root = root;
            this.filename = filename;
            this.xpathexpression = xpath;
        }

        public String call() throws IOException {
            File file = new File(this.root, this.filename);
            String result = "";
            if (file.exists()) {
                try {
                    DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dFactory.newDocumentBuilder();
                    Document doc = builder.parse(file.toString());
                    XPath xpathInstance = XPathFactory.newInstance().newXPath();
                    XPathExpression expr = xpathInstance.compile(this.xpathexpression);
                    Object res = expr.evaluate(doc, XPathConstants.NODESET);
                    NodeList nodes = (NodeList)res;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        result = result.concat(nodes.item(i).getNodeValue()).concat(";");
                    }
                    result = result.substring(0, result.length() - 1);
                }
                catch (IOException e) {
                    result = "Error: ".concat(this.filename).concat(" - Could not read XML file.");
                }
                catch (SAXException e) {
                    result = "Error: ".concat(this.filename).concat(" - XML not well formed.");
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Unhandled exception during the macro evaluation", e);
                    result = "Error: ".concat(this.filename).concat(" - '").concat(this.xpathexpression).concat("' invalid syntax or path maybe?");
                }
            } else {
                result = "Error: ".concat(this.filename).concat(" not found");
            }
            return result;
        }
    }
}

