/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class WorkspaceFileMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter(required=true)
    public String path = "";
    @DataBoundTokenMacro.Parameter
    public String fileNotFoundMessage = "ERROR: File '%s' does not exist";
    public static final String MACRO_NAME = "FILE";

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        try {
            EnvVars env = context.getEnvironment(listener);
            this.path = env.expand(this.path);
        }
        catch (Exception e) {
            listener.error("Error retrieving environment: %s", new Object[]{e.getMessage()});
        }
        FilePath workspace = this.getWorkspace(context, macroName);
        if (!workspace.child(this.path).exists()) {
            return String.format(this.fileNotFoundMessage, this.path);
        }
        try {
            return workspace.child(this.path).readToString();
        }
        catch (IOException e) {
            return "ERROR: File '" + this.path + "' could not be read";
        }
    }

    @Override
    public boolean hasNestedContent() {
        return true;
    }
}

