/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.pipeline;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.timestamper.Messages;
import hudson.plugins.timestamper.TimestamperConfig;
import hudson.plugins.timestamper.pipeline.GlobalDecorator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import jenkins.YesNoMaybe;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TimestamperStep
extends Step {
    @DataBoundConstructor
    public TimestamperStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(context);
    }

    @Deprecated
    private static class TimestampNotesConsoleLogFilter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TimestampNotesConsoleLogFilter() {
        }

        public OutputStream decorateLogger(Run _ignore, OutputStream logger) throws IOException, InterruptedException {
            return logger;
        }
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.Timestamps();
        }

        public String getFunctionName() {
            return "timestamps";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getHelpFile() {
            return this.getDescriptorFullUrl() + "/help";
        }

        public void doHelp(StaplerRequest request, StaplerResponse response) throws IOException {
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.println(Messages.Description());
            writer.flush();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }

    private static class ExecutionImpl
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;

        ExecutionImpl(StepContext context) {
            super(context);
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            BodyInvoker invoker = context.newBodyInvoker().withCallback(BodyExecutionCallback.wrap((FutureCallback)context));
            if (TimestamperConfig.get().isAllPipelines()) {
                ((TaskListener)context.get(TaskListener.class)).getLogger().println("The timestamps step is unnecessary when timestamps are enabled for all Pipeline builds.");
            } else {
                invoker.withContext((Object)TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)context.get(TaskListenerDecorator.class)), (TaskListenerDecorator)new GlobalDecorator()));
            }
            invoker.start();
            return false;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
        }
    }
}

