/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.plugins.timestamper.TimestamperConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;

public final class GlobalDecorator
extends TaskListenerDecorator {
    private static final Logger LOGGER = Logger.getLogger(GlobalDecorator.class.getName());
    static final DateTimeFormatter UTC_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private static final long serialVersionUID = 1L;

    GlobalDecorator() {
    }

    @NonNull
    public OutputStream decorate(@NonNull OutputStream logger) throws IOException, InterruptedException {
        return new GlobalDecoratorLineTransformationOutputStream(logger);
    }

    @Extension
    public static final class Factory
    implements TaskListenerDecorator.Factory {
        public TaskListenerDecorator of(@NonNull FlowExecutionOwner owner) {
            if (!TimestamperConfig.get().isAllPipelines()) {
                return null;
            }
            try {
                Queue.Executable executable = owner.getExecutable();
                if (executable instanceof Run) {
                    return new GlobalDecorator();
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            return null;
        }
    }

    private static class GlobalDecoratorLineTransformationOutputStream
    extends LineTransformationOutputStream {
        private final OutputStream logger;

        public GlobalDecoratorLineTransformationOutputStream(OutputStream logger) {
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void eol(byte[] b, int len) throws IOException {
            OutputStream outputStream = this.logger;
            synchronized (outputStream) {
                ByteBuffer buffer = ByteBuffer.allocate(27 + len);
                buffer.put((byte)91);
                buffer.put(ZonedDateTime.now(ZoneOffset.UTC).format(UTC_MILLIS).getBytes(StandardCharsets.US_ASCII));
                buffer.put((byte)93);
                buffer.put((byte)32);
                buffer.put(b, 0, len);
                this.logger.write(buffer.array(), 0, buffer.position());
            }
        }

        public void flush() throws IOException {
            this.logger.flush();
        }

        public void close() throws IOException {
            super.close();
            this.logger.close();
        }
    }
}

