/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.format;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.Sanitizers;

@Restricted(value={NoExternalUse.class})
public class TimestampFormatUtils {
    private static final Logger LOGGER = Logger.getLogger(TimestampFormatUtils.class.getName());

    public static String sanitize(@NonNull String input) {
        StringBuilder sb = new StringBuilder();
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create((StringBuilder)sb, TimestampFormatUtils::handle);
        HtmlSanitizer.sanitize((String)input, (HtmlSanitizer.Policy)Sanitizers.FORMATTING.apply((HtmlStreamEventReceiver)renderer));
        return sb.toString();
    }

    private static void handle(@NonNull String html) {
        LOGGER.log(Level.WARNING, "Invalid HTML: " + html);
    }
}

