/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.format;

import hudson.plugins.timestamper.TimestamperConfig;
import hudson.plugins.timestamper.format.ElapsedTimestampFormat;
import hudson.plugins.timestamper.format.EmptyTimestampFormat;
import hudson.plugins.timestamper.format.SystemTimestampFormat;
import hudson.plugins.timestamper.format.TimeZoneUtils;
import hudson.plugins.timestamper.format.TimestampFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class TimestampFormatProvider {
    private static Supplier<TimestampFormat> SUPPLIER = () -> {
        TimestamperConfig config = TimestamperConfig.get();
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request == null) {
            return EmptyTimestampFormat.INSTANCE;
        }
        return TimestampFormatProvider.get(config.getSystemTimeFormat(), config.getElapsedTimeFormat(), (HttpServletRequest)request, Locale.getDefault());
    };

    public static TimestampFormat get() {
        return SUPPLIER.get();
    }

    static TimestampFormat get(String systemTimeFormat, String elapsedTimeFormat, HttpServletRequest request, Locale locale) {
        String mode = null;
        Boolean local = null;
        String offset = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (mode == null && "jenkins-timestamper".equals(cookie.getName())) {
                    mode = cookie.getValue();
                }
                if (local == null && "jenkins-timestamper-local".equals(cookie.getName())) {
                    local = Boolean.valueOf(cookie.getValue());
                }
                if (offset != null || !"jenkins-timestamper-offset".equals(cookie.getName())) continue;
                offset = cookie.getValue();
            }
        }
        if ("elapsed".equalsIgnoreCase(mode)) {
            return new ElapsedTimestampFormat(elapsedTimeFormat);
        }
        if ("none".equalsIgnoreCase(mode)) {
            return EmptyTimestampFormat.INSTANCE;
        }
        Optional<String> timeZoneId = Optional.empty();
        if (local != null && local.booleanValue()) {
            try {
                String localTimeZoneId = TimestampFormatProvider.convertOffsetToTimeZoneId(offset);
                timeZoneId = Optional.of(localTimeZoneId);
            }
            catch (NumberFormatException e) {
                return EmptyTimestampFormat.INSTANCE;
            }
        }
        return new SystemTimestampFormat(systemTimeFormat, timeZoneId, locale);
    }

    private static String convertOffsetToTimeZoneId(String offset) {
        long offsetInMillis = -Integer.parseInt(offset);
        return TimeZoneUtils.getTimeZoneId(offsetInMillis);
    }
}

