/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.format;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.format.FormatParseException;
import hudson.plugins.timestamper.format.FormatStringUtils;
import hudson.plugins.timestamper.format.InvalidHtmlException;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormatUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.FastDateFormat;

public final class SystemTimestampFormat
extends TimestampFormat {
    private static final String TIME_ZONE_PROPERTY = "org.apache.commons.jelly.tags.fmt.timeZone";
    private final FastDateFormat format;
    private final Optional<String> timeZoneId;

    public SystemTimestampFormat(String systemTimeFormat, Optional<String> timeZoneId, Locale locale) {
        TimeZone timeZone = null;
        if (timeZoneId.isPresent()) {
            timeZone = TimeZone.getTimeZone(timeZoneId.get());
        } else {
            String timeZoneProperty = System.getProperty(TIME_ZONE_PROPERTY);
            if (timeZoneProperty != null) {
                timeZone = TimeZone.getTimeZone(timeZoneProperty);
            }
        }
        try {
            this.format = FastDateFormat.getInstance((String)systemTimeFormat, (TimeZone)timeZone, (Locale)locale);
        }
        catch (IllegalArgumentException e) {
            throw new FormatParseException(e);
        }
        this.timeZoneId = timeZoneId;
    }

    @Override
    public String apply(@NonNull Timestamp timestamp) {
        String result = this.format.format(new Date(timestamp.millisSinceEpoch));
        return TimestampFormatUtils.sanitize(result);
    }

    @Override
    public void validate() throws FormatParseException, InvalidHtmlException {
        String result;
        try {
            result = this.format.format(new Date(0L));
        }
        catch (IllegalArgumentException e) {
            throw new FormatParseException(e);
        }
        String sanitized = TimestampFormatUtils.sanitize(result);
        if (!sanitized.equals(result)) {
            throw new InvalidHtmlException();
        }
    }

    @Override
    public String getPlainTextUrl() {
        String timeParamValue = this.format.getPattern();
        timeParamValue = FormatStringUtils.stripHtmlTags(timeParamValue);
        timeParamValue = FormatStringUtils.trim(timeParamValue);
        return "timestamps/?time=" + timeParamValue + this.timeZoneId.map(s -> "&timeZone=" + s).orElse("") + "&appendLog&locale=" + this.format.getLocale();
    }

    public int hashCode() {
        return Objects.hash(this.format, this.timeZoneId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SystemTimestampFormat) {
            SystemTimestampFormat other = (SystemTimestampFormat)obj;
            return this.format.equals((Object)other.format) && this.timeZoneId.equals(other.timeZoneId);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("format", (Object)this.format.getPattern()).append("timeZoneId", this.timeZoneId).append("locale", (Object)this.format.getLocale()).toString();
    }
}

