/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.accessor;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.ConsoleNote;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.TimestampNote;
import hudson.plugins.timestamper.accessor.TimestampLogFileLine;
import hudson.plugins.timestamper.io.TimestampsReader;
import hudson.plugins.timestamper.pipeline.GlobalAnnotator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.io.input.CountingInputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@SuppressFBWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Line count lambda is just counting lines, not reading them")
public class TimestampLogFileLineAccessor
implements Closeable {
    private final Run<?, ?> build;
    private final Scanner logFileReader;
    private final TimestampsReader timestampsReader;
    private final java.util.function.Supplier<Integer> lineCount;

    public TimestampLogFileLineAccessor(Run<?, ?> build) throws IOException {
        this.build = Objects.requireNonNull(build);
        this.logFileReader = new Scanner(build.getLogReader()).useDelimiter("\n");
        this.timestampsReader = new TimestampsReader(build);
        this.lineCount = () -> ((Supplier)Suppliers.memoize(() -> {
            int lineCount = 0;
            try (Scanner lineCountReader = new Scanner(build.getLogReader()).useDelimiter("\n");){
                while (lineCountReader.hasNext()) {
                    lineCountReader.next();
                    ++lineCount;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return lineCount;
        })).get();
    }

    public void skipLine() throws IOException {
        this.timestampsReader.read();
        if (this.logFileReader.hasNext()) {
            this.logFileReader.next();
        }
    }

    public TimestampLogFileLine readLine() throws IOException {
        String logFileLine = this.logFileReader.hasNext() ? this.logFileReader.next() : null;
        Timestamp timestamp = this.timestampsReader.read().orElse(null);
        if (timestamp == null && logFileLine != null) {
            timestamp = GlobalAnnotator.parseTimestamp(logFileLine, this.build.getStartTimeInMillis()).orElse(null);
            if (timestamp != null) {
                logFileLine = logFileLine.substring(27);
            } else {
                timestamp = this.readTimestamp(logFileLine).orElse(null);
            }
        }
        return new TimestampLogFileLine(timestamp, logFileLine);
    }

    private Optional<Timestamp> readTimestamp(String line) {
        byte[] bytes = line.getBytes(this.build.getCharset());
        int length = bytes.length;
        int index = 0;
        while ((index = ConsoleNote.findPreamble((byte[])bytes, (int)index, (int)(length - index))) != -1) {
            CountingInputStream inputStream = new CountingInputStream((InputStream)new ByteArrayInputStream(bytes, index, length - index));
            try {
                ConsoleNote consoleNote = ConsoleNote.readFrom((DataInputStream)new DataInputStream((InputStream)inputStream));
                if (consoleNote instanceof TimestampNote) {
                    TimestampNote timestampNote = (TimestampNote)consoleNote;
                    Timestamp timestamp = timestampNote.getTimestamp(this.build);
                    return Optional.of(timestamp);
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            index += Math.max(inputStream.getCount(), 1);
        }
        return Optional.empty();
    }

    public int getLineCount() {
        return this.lineCount.get();
    }

    @Override
    public void close() throws IOException {
        this.timestampsReader.close();
        this.logFileReader.close();
    }
}

