/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.timestamper.Messages;
import hudson.plugins.timestamper.TimestampNote;
import hudson.plugins.timestamper.TimestampNotesOutputStream;
import hudson.plugins.timestamper.TimestamperOutputStream;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.TimestampsWriter;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;

public final class TimestamperBuildWrapper
extends SimpleBuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(TimestamperBuildWrapper.class.getName());

    @DataBoundConstructor
    public TimestamperBuildWrapper() {
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
    }

    public ConsoleLogFilter createLoggerDecorator(@NonNull Run<?, ?> build) {
        return new ConsoleLogFilterImpl(build);
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.Description();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    private static class ConsoleLogFilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final File timestampsFile;
        private final long buildStartTime;
        private final boolean useTimestampNotes;

        ConsoleLogFilterImpl(Run<?, ?> build) {
            this.timestampsFile = TimestamperPaths.timestampsFile(build).toFile();
            this.buildStartTime = build.getStartTimeInMillis();
            this.useTimestampNotes = TimestampNote.useTimestampNotes(build.getClass()) || Boolean.getBoolean(TimestampNote.getSystemProperty());
        }

        public OutputStream decorateLogger(Run _ignore, OutputStream logger) throws IOException, InterruptedException {
            if (this.useTimestampNotes) {
                return new TimestampNotesOutputStream(logger, this.buildStartTime);
            }
            Optional<MessageDigest> digest = Optional.empty();
            try {
                digest = Optional.of(MessageDigest.getInstance("SHA-1"));
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            try {
                TimestampsWriter timestampsWriter = new TimestampsWriter(this.timestampsFile.toPath(), this.buildStartTime, digest);
                logger = new TimestamperOutputStream(logger, timestampsWriter);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            return logger;
        }
    }
}

