/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.util;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.plugins.testlink.Report;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.util.VariableResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public final class TestLinkHelper {
    private static final String TESTLINK_TESTCASE_PREFIX = "TESTLINK_TESTCASE_";
    private static final String TESTLINK_TESTPLAN_PREFIX = "TESTLINK_TESTPLAN_";
    private static final String TESTLINK_BUILD_PREFIX = "TESTLINK_BUILD_";
    private static final String TESTLINK_TESTCASE_STEP_PREFIX = "TESTLINK_TESTCASE_STEP_";
    private static final String TESTLINK_TESTCASE_ID_ENVVAR = "TESTLINK_TESTCASE_ID";
    private static final String TESTLINK_TESTCASE_NAME_ENVVAR = "TESTLINK_TESTCASE_NAME";
    private static final String TESTLINK_TESTCASE_TESTSUITE_ID_ENVVAR = "TESTLINK_TESTCASE_TESTSUITEID";
    private static final String TESTLINK_TESTCASE_TESTPROJECT_ID = "TESTLINK_TESTCASE_TESTPROJECTID";
    private static final String TESTLINK_TESTCASE_AUTHOR_ENVVAR = "TESTLINK_TESTCASE_AUTHOR";
    private static final String TESTLINK_TESTCASE_SUMMARY_ENVVAR = "TESTLINK_TESTCASE_SUMMARY";
    private static final String TESTLINK_BUILD_NAME_ENVVAR = "TESTLINK_BUILD_NAME";
    private static final String TESTLINK_TESTPLAN_NAME_ENVVAR = "TESTLINK_TESTPLAN_NAME";
    private static final String TESTLINK_TESTPROJECT_NAME_ENVVAR = "TESTLINK_TESTPROJECT_NAME";
    private static final String TESTLINK_TESTCASE_EXTERNAL_ID_ENVVAR = "TESTLINK_TESTCASE_EXTERNAL_ID";
    private static final String TESTLINK_TESTCASE_VERSION_ENVVAR = "TESTLINK_TESTCASE_VERSION";
    private static final String BASIC_HTTP_PASSWORD = "basicPassword";
    private static final String COMMA = ",";

    private TestLinkHelper() {
    }

    public static String getExecutionStatusTextColored(ExecutionStatus executionStatus) {
        String executionStatusTextColored = "Undefined";
        if (executionStatus == ExecutionStatus.FAILED) {
            executionStatusTextColored = "<span style='color: red'>Failed</span>";
        } else if (executionStatus == ExecutionStatus.PASSED) {
            executionStatusTextColored = "<span style='color: green'>Passed</span>";
        } else if (executionStatus == ExecutionStatus.BLOCKED) {
            executionStatusTextColored = "<span style='color: yellow'>Blocked</span>";
        } else if (executionStatus == ExecutionStatus.NOT_RUN) {
            executionStatusTextColored = "<span style='color: gray'>Not Run</span>";
        }
        return executionStatusTextColored;
    }

    public static void setTestLinkJavaAPIProperties(String testLinkJavaAPIProperties, BuildListener listener) {
        StringTokenizer tokenizer;
        if (StringUtils.isNotBlank((String)testLinkJavaAPIProperties) && (tokenizer = new StringTokenizer(testLinkJavaAPIProperties, COMMA)).countTokens() > 0) {
            while (tokenizer.hasMoreTokens()) {
                String systemProperty = tokenizer.nextToken();
                TestLinkHelper.maybeAddSystemProperty(systemProperty, listener);
            }
        }
    }

    public static void maybeAddSystemProperty(String systemProperty, BuildListener listener) {
        StringTokenizer tokenizer = new StringTokenizer(systemProperty, "=:");
        if (tokenizer.countTokens() == 2) {
            String key = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
                if (key.contains(BASIC_HTTP_PASSWORD)) {
                    listener.getLogger().println(Messages.TestLinkBuilder_SettingSystemProperty(key, "********"));
                } else {
                    listener.getLogger().println(Messages.TestLinkBuilder_SettingSystemProperty(key, value));
                }
                try {
                    System.setProperty(key, value);
                }
                catch (SecurityException se) {
                    se.printStackTrace(listener.getLogger());
                }
            }
        }
    }

    public static Map<String, String> createTestLinkEnvironmentVariables(TestCaseWrapper testCase, TestProject testProject, TestPlan testPlan, Build build) {
        HashMap<String, String> testLinkEnvVar = new HashMap<String, String>();
        testLinkEnvVar.put(TESTLINK_TESTCASE_ID_ENVVAR, "" + testCase.getId());
        testLinkEnvVar.put(TESTLINK_TESTCASE_NAME_ENVVAR, StringUtils.defaultIfEmpty((String)testCase.getName(), (String)""));
        testLinkEnvVar.put(TESTLINK_TESTCASE_TESTSUITE_ID_ENVVAR, "" + testCase.getTestSuiteId());
        testLinkEnvVar.put(TESTLINK_TESTCASE_TESTPROJECT_ID, "" + testCase.getTestProjectId());
        testLinkEnvVar.put(TESTLINK_TESTCASE_AUTHOR_ENVVAR, "" + testCase.getAuthorLogin());
        testLinkEnvVar.put(TESTLINK_TESTCASE_SUMMARY_ENVVAR, StringUtils.defaultIfEmpty((String)testCase.getSummary(), (String)""));
        testLinkEnvVar.put(TESTLINK_BUILD_NAME_ENVVAR, StringUtils.defaultIfEmpty((String)build.getName(), (String)""));
        testLinkEnvVar.put(TESTLINK_TESTPLAN_NAME_ENVVAR, StringUtils.defaultIfEmpty((String)testPlan.getName(), (String)""));
        testLinkEnvVar.put(TESTLINK_TESTPROJECT_NAME_ENVVAR, StringUtils.defaultIfEmpty((String)testProject.getName(), (String)""));
        testLinkEnvVar.put(TESTLINK_TESTCASE_EXTERNAL_ID_ENVVAR, StringUtils.defaultIfEmpty((String)testCase.getFullExternalId(), (String)""));
        testLinkEnvVar.put(TESTLINK_TESTCASE_VERSION_ENVVAR, "" + testCase.getVersion());
        List<CustomField> testCaseCustomFields = testCase.getCustomFields();
        for (CustomField customField : testCaseCustomFields) {
            TestLinkHelper.addCustomFieldEnvironmentVariableName(customField, testLinkEnvVar, TESTLINK_TESTCASE_PREFIX);
        }
        List testPlanCustomFields = testPlan.getCustomFields();
        for (CustomField customField : testPlanCustomFields) {
            TestLinkHelper.addCustomFieldEnvironmentVariableName(customField, testLinkEnvVar, TESTLINK_TESTPLAN_PREFIX);
        }
        List<TestCaseStep> list = testCase.getSteps();
        testLinkEnvVar.put("TESTLINK_TESTCASE_STEP_TOTAL", Integer.toString(list.size()));
        for (TestCaseStep step : list) {
            String action = step.getActions();
            testLinkEnvVar.put(TESTLINK_TESTCASE_STEP_PREFIX + step.getNumber() + "_ACTION", action);
            String expected = step.getExpectedResults();
            testLinkEnvVar.put(TESTLINK_TESTCASE_STEP_PREFIX + step.getNumber() + "_EXPECTED", expected);
        }
        return testLinkEnvVar;
    }

    public static Map<String, String> createTestLinkEnvironmentVariables(int numberOfTests, TestProject testProject, TestPlan testPlan, Build build) {
        HashMap<String, String> testLinkEnvVar = new HashMap<String, String>();
        testLinkEnvVar.put(TESTLINK_BUILD_NAME_ENVVAR, StringUtils.defaultIfEmpty((String)build.getName(), (String)""));
        testLinkEnvVar.put(TESTLINK_TESTPLAN_NAME_ENVVAR, StringUtils.defaultIfEmpty((String)testPlan.getName(), (String)""));
        testLinkEnvVar.put(TESTLINK_TESTPROJECT_NAME_ENVVAR, StringUtils.defaultIfEmpty((String)testProject.getName(), (String)""));
        testLinkEnvVar.put("TESTLINK_TESTCASE_TOTAL", Integer.toString(numberOfTests));
        return testLinkEnvVar;
    }

    public static void addCustomFieldEnvironmentVariableName(CustomField customField, Map<String, String> testLinkEnvVar, String prefix) {
        StringTokenizer tokenizer;
        String customFieldName = customField.getName();
        String customFieldValue = customField.getValue();
        customFieldName = customFieldName.toUpperCase();
        customFieldName = customFieldName.trim();
        customFieldName = prefix + customFieldName;
        customFieldName = customFieldName.replaceAll("\\s+", "_");
        testLinkEnvVar.put(customFieldName, customFieldValue);
        if (StringUtils.isNotBlank((String)customFieldValue) && (tokenizer = new StringTokenizer(customFieldValue, COMMA)).countTokens() > 1) {
            int index = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                token = token.trim();
                customFieldName = customField.getName();
                customFieldName = customFieldName.toUpperCase();
                customFieldName = customFieldName.trim();
                String tokenName = prefix + customFieldName + "_" + index;
                tokenName = tokenName.replaceAll("\\s+", "_");
                testLinkEnvVar.put(tokenName, token);
                ++index;
            }
        }
    }

    public static EnvVars buildTestCaseEnvVars(TestCaseWrapper testCase, TestProject testProject, TestPlan testPlan, Build build, BuildListener listener) {
        Map<String, String> testLinkEnvironmentVariables = TestLinkHelper.createTestLinkEnvironmentVariables(testCase, testProject, testPlan, build);
        listener.getLogger().println(Messages.TestLinkBuilder_MergingEnvVars());
        EnvVars buildEnvironment = new EnvVars(testLinkEnvironmentVariables);
        return buildEnvironment;
    }

    public static EnvVars buildTestCaseEnvVars(int numberOfTests, TestProject testProject, TestPlan testPlan, Build build, BuildListener listener) {
        Map<String, String> testLinkEnvironmentVariables = TestLinkHelper.createTestLinkEnvironmentVariables(numberOfTests, testProject, testPlan, build);
        listener.getLogger().println(Messages.TestLinkBuilder_MergingEnvVars());
        EnvVars buildEnvironment = new EnvVars(testLinkEnvironmentVariables);
        return buildEnvironment;
    }

    public static String createReportSummary(Report testLinkReport, Report previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("<p><b>" + Messages.ReportSummary_Summary_BuildID(testLinkReport.getBuildId()) + "</b></p>");
        builder.append("<p><b>" + Messages.ReportSummary_Summary_BuildName(Util.escape((String)testLinkReport.getBuildName())) + "</b></p>");
        builder.append("<p><a href=\"testLinkResult\">");
        Integer total = testLinkReport.getTestsTotal();
        Integer previousTotal = previous != null ? previous.getTestsTotal() : total.intValue();
        Integer passed = testLinkReport.getPassed();
        Integer previousPassed = previous != null ? previous.getPassed() : passed.intValue();
        Integer failed = testLinkReport.getFailed();
        Integer previousFailed = previous != null ? previous.getFailed() : failed.intValue();
        Integer blocked = testLinkReport.getBlocked();
        Integer previousBlocked = previous != null ? previous.getBlocked() : blocked.intValue();
        Integer notRun = testLinkReport.getNotRun();
        Integer previousNotRun = previous != null ? previous.getNotRun() : notRun.intValue();
        builder.append(Messages.ReportSummary_Summary_Text(total + TestLinkHelper.getPlusSignal(total, previousTotal), passed + TestLinkHelper.getPlusSignal(passed, previousPassed), failed + TestLinkHelper.getPlusSignal(failed, previousFailed), blocked + TestLinkHelper.getPlusSignal(blocked, previousBlocked), notRun + TestLinkHelper.getPlusSignal(notRun, previousNotRun)));
        builder.append("</p>");
        return builder.toString();
    }

    public static String createReportSummaryDetails(Report report, Report previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("<p>" + Messages.ReportSummary_Details_Header() + "</p>");
        builder.append("<table border=\"1\">\n");
        builder.append("<tr><th>");
        builder.append(Messages.ReportSummary_Details_TestCaseId());
        builder.append("</th><th>");
        builder.append(Messages.ReportSummary_Details_TestCaseExternalId());
        builder.append("</th><th>");
        builder.append(Messages.ReportSummary_Details_Version());
        builder.append("</th><th>");
        builder.append(Messages.ReportSummary_Details_Name());
        builder.append("</th><th>");
        builder.append(Messages.ReportSummary_Details_TestProjectId());
        builder.append("</th><th>");
        builder.append(Messages.ReportSummary_Details_ExecutionStatus());
        builder.append("</th></tr>\n");
        for (TestCaseWrapper tc : report.getTestCases()) {
            builder.append("<tr>\n");
            builder.append("<td>" + tc.getId() + "</td>");
            builder.append("<td>" + Util.escape((String)tc.getFullExternalId()) + "</td>");
            builder.append("<td>" + tc.getVersion() + "</td>");
            builder.append("<td>" + Util.escape((String)tc.getName()) + "</td>");
            builder.append("<td>" + tc.getTestProjectId() + "</td>");
            builder.append("<td>" + TestLinkHelper.getExecutionStatusTextColored(tc.getExecutionStatus()) + "</td>\n");
            builder.append("</tr>\n");
        }
        builder.append("</table>");
        return builder.toString();
    }

    public static String getPlusSignal(int current, int previous) {
        int difference = current - previous;
        return difference > 0 ? " (+" + difference + ")" : "";
    }

    public static String[] createArrayOfCustomFieldsNames(VariableResolver<String> variableResolver, EnvVars envVars, String customFields) {
        StringTokenizer tokenizer;
        String[] customFieldNamesArray = new String[]{};
        String expandedCustomFields = TestLinkHelper.expandVariable(variableResolver, envVars, customFields);
        if (StringUtils.isNotBlank((String)expandedCustomFields) && (tokenizer = new StringTokenizer(expandedCustomFields, COMMA)).countTokens() > 0) {
            customFieldNamesArray = new String[tokenizer.countTokens()];
            int index = 0;
            while (tokenizer.hasMoreTokens()) {
                String customFieldName = tokenizer.nextToken();
                customFieldNamesArray[index] = customFieldName = customFieldName.trim();
                ++index;
            }
        }
        return customFieldNamesArray;
    }

    public static String expandVariable(VariableResolver<String> variableResolver, EnvVars envVars, String variable) {
        return Util.replaceMacro((String)envVars.expand(variable), variableResolver);
    }
}

