/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import com.tupilabs.testng.parser.Class;
import com.tupilabs.testng.parser.Suite;
import com.tupilabs.testng.parser.Test;
import com.tupilabs.testng.parser.TestMethod;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.AbstractTestNGResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerDescriptor;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class TestNGMethodNameResultSeeker
extends AbstractTestNGResultSeeker {
    private static final long serialVersionUID = 3885800916930897675L;

    @DataBoundConstructor
    public TestNGMethodNameResultSeeker(String includePattern, String keyCustomField, boolean attachTestNGXML, boolean markSkippedTestAsBlocked, boolean includeNotes) {
        super(includePattern, keyCustomField, attachTestNGXML, markSkippedTestAsBlocked, includeNotes);
    }

    @Override
    public void seek(TestCaseWrapper[] automatedTestCases, AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener, TestLinkSite testlink) throws ResultSeekerException {
        listener.getLogger().println(Messages.Results_TestNG_LookingForTestMethod());
        try {
            List suites = (List)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<List<Suite>>(){
                private static final long serialVersionUID = 1L;
                private List<Suite> suites = new ArrayList<Suite>();

                public List<Suite> invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                    String[] xmls;
                    for (String xml : xmls = TestNGMethodNameResultSeeker.this.scan(workspace, TestNGMethodNameResultSeeker.this.includePattern, listener)) {
                        File input = new File(workspace, xml);
                        List suitz = TestNGMethodNameResultSeeker.this.getParser().parse(input);
                        for (Suite suite : suitz) {
                            this.suites.add(suite);
                        }
                    }
                    return this.suites;
                }
            });
            for (Suite suite : suites) {
                for (Test test : suite.getTests()) {
                    for (Class clazz : test.getClasses()) {
                        for (TestMethod method : clazz.getTestMethods()) {
                            for (TestCaseWrapper automatedTestCase : automatedTestCases) {
                                String[] commaSeparatedValues;
                                String qualifiedName = clazz.getName() + '#' + method.getName();
                                for (String value : commaSeparatedValues = automatedTestCase.getKeyCustomFieldValues(this.keyCustomField)) {
                                    if (!qualifiedName.equals(value)) continue;
                                    ExecutionStatus status = this.getExecutionStatus(method);
                                    if (status != ExecutionStatus.NOT_RUN) {
                                        automatedTestCase.addCustomFieldAndStatus(value, status);
                                    }
                                    if (this.isIncludeNotes()) {
                                        String notes = this.getTestNGNotes(method);
                                        automatedTestCase.appendNotes(notes);
                                    }
                                    super.handleResult(automatedTestCase, build, listener, testlink, status, suite);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ResultSeekerException(e);
        }
        catch (InterruptedException e) {
            throw new ResultSeekerException(e);
        }
    }

    private ExecutionStatus getExecutionStatus(TestMethod method) {
        if (StringUtils.isNotBlank((String)method.getStatus())) {
            if (method.getStatus().equals("FAIL")) {
                return ExecutionStatus.FAILED;
            }
            if (method.getStatus().equals("SKIP")) {
                if (this.isMarkSkippedTestAsBlocked()) {
                    return ExecutionStatus.BLOCKED;
                }
                return ExecutionStatus.NOT_RUN;
            }
        }
        return ExecutionStatus.PASSED;
    }

    private String getTestNGNotes(TestMethod method) {
        StringBuilder notes = new StringBuilder();
        notes.append(Messages.Results_TestNG_NotesForMethods(method.getName(), method.getIsConfig(), method.getSignature(), method.getStatus(), method.getDurationMs(), method.getStartedAt(), method.getFinishedAt()));
        return notes.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ResultSeekerDescriptor {
        public String getDisplayName() {
            return "TestNG method name";
        }
    }
}

