/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class TestCaseWrapper
implements Serializable {
    private static final long serialVersionUID = 6440057711152759081L;
    private final Map<String, ExecutionStatus> customFieldAndStatus;
    private List<Attachment> attachments;
    private StringBuilder notes;
    private String platform = null;
    private TestCase testCase;

    public TestCaseWrapper() {
        this(new TestCase());
    }

    public TestCaseWrapper(TestCase testCase) {
        this.testCase = testCase;
        this.notes = new StringBuilder();
        this.attachments = new LinkedList<Attachment>();
        this.customFieldAndStatus = new HashMap<String, ExecutionStatus>();
    }

    public void addCustomFieldAndStatus(String customField, ExecutionStatus executionStatus) {
        this.customFieldAndStatus.put(customField, executionStatus);
    }

    public Map<String, ExecutionStatus> getCustomFieldAndStatus() {
        return this.customFieldAndStatus;
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public String getNotes() {
        return this.notes.toString();
    }

    public void appendNotes(String notes) {
        this.notes.append(notes);
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.testCase.getExecutionStatus() == null ? ExecutionStatus.NOT_RUN : this.testCase.getExecutionStatus();
    }

    public ExecutionStatus getExecutionStatus(String keyCustomFieldName) {
        String[] keyCustomFieldValues = this.getKeyCustomFieldValues(keyCustomFieldName);
        int numberOfCustomFields = keyCustomFieldValues.length;
        ExecutionStatus status = ExecutionStatus.NOT_RUN;
        if (this.customFieldAndStatus.size() > 0 && this.customFieldAndStatus.size() == numberOfCustomFields) {
            status = ExecutionStatus.PASSED;
            for (ExecutionStatus reportedStatus : this.customFieldAndStatus.values()) {
                if (reportedStatus != ExecutionStatus.FAILED && reportedStatus != ExecutionStatus.BLOCKED) continue;
                status = reportedStatus;
                break;
            }
        }
        this.testCase.setExecutionStatus(status);
        return status;
    }

    public Integer getId() {
        return this.testCase.getId();
    }

    public void setId(Integer id) {
        this.testCase.setId(id);
    }

    public String getName() {
        return this.testCase.getName();
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.testCase.setCustomFields(customFields);
    }

    public List<CustomField> getCustomFields() {
        return this.testCase.getCustomFields();
    }

    public String[] getKeyCustomFieldValues(String keyCustomFieldName) {
        String keyCustomFieldValue = null;
        for (CustomField customField : this.getCustomFields()) {
            if (!customField.getName().equals(keyCustomFieldName)) continue;
            keyCustomFieldValue = customField.getValue();
            break;
        }
        return this.split(keyCustomFieldValue);
    }

    public String getKeyCustomFieldValue(String keyCustomFieldName) {
        String keyCustomFieldValue = null;
        for (CustomField customField : this.getCustomFields()) {
            if (!customField.getName().equals(keyCustomFieldName)) continue;
            keyCustomFieldValue = customField.getValue();
            break;
        }
        return keyCustomFieldValue;
    }

    protected String[] split(String input) {
        if (StringUtils.isBlank((String)input)) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(input, ",");
        String[] values = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            values[i] = tokenizer.nextToken().trim();
            ++i;
        }
        return values;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.testCase.setExecutionStatus(executionStatus);
    }

    public void setName(String name) {
        this.testCase.setName(name);
    }

    public Integer getInternalId() {
        return this.testCase.getInternalId();
    }

    public void setInternalId(Integer internalId) {
        this.testCase.setInternalId(internalId);
    }

    public Integer getExecutionOrder() {
        return this.testCase.getExecutionOrder();
    }

    public void setExecutionOrder(Integer executionOrder) {
        this.testCase.setExecutionOrder(executionOrder);
    }

    public Integer getTestSuiteId() {
        return this.testCase.getTestSuiteId();
    }

    public void setTestSuiteId(Integer testSuiteId) {
        this.testCase.setTestSuiteId(testSuiteId);
    }

    public Integer getTestProjectId() {
        return this.testCase.getTestProjectId();
    }

    public void setTestProjectId(Integer testProjectId) {
        this.testCase.setTestProjectId(testProjectId);
    }

    public String getAuthorLogin() {
        return this.testCase.getAuthorLogin();
    }

    public void setAuthorLogin(String authorLogin) {
        this.testCase.setAuthorLogin(authorLogin);
    }

    public String getSummary() {
        return this.testCase.getSummary();
    }

    public void setSummary(String summary) {
        this.testCase.setSummary(summary);
    }

    public List<TestCaseStep> getSteps() {
        return this.testCase.getSteps();
    }

    public void setSteps(List<TestCaseStep> steps) {
        this.testCase.setSteps(steps);
    }

    public Integer getVersion() {
        return this.testCase.getVersion();
    }

    public String getFullExternalId() {
        return this.testCase.getFullExternalId();
    }

    public void setFullExternalId(String fullExternalId) {
        this.testCase.setFullExternalId(fullExternalId);
    }
}

