/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.AbstractJUnitResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerDescriptor;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class JUnitCaseClassNameResultSeeker
extends AbstractJUnitResultSeeker {
    private static final long serialVersionUID = -7504474094868139409L;

    @DataBoundConstructor
    public JUnitCaseClassNameResultSeeker(String includePattern, String keyCustomField, boolean attachJUnitXML, boolean includeNotes) {
        super(includePattern, keyCustomField, attachJUnitXML, includeNotes);
    }

    @Override
    public void seek(TestCaseWrapper[] automatedTestCases, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestLinkSite testlink) throws ResultSeekerException {
        listener.getLogger().println(Messages.Results_JUnit_LookingForTestClasses());
        try {
            JUnitParser parser = new JUnitParser(false);
            TestResult testResult = parser.parse(this.includePattern, build, launcher, (TaskListener)listener);
            for (SuiteResult suiteResult : testResult.getSuites()) {
                List<CaseResult> caseResults = this.filter(suiteResult.getCases());
                HashMap<String, TestCaseWrapper> classNameTestCase = new HashMap<String, TestCaseWrapper>();
                for (CaseResult caseResult : caseResults) {
                    for (TestCaseWrapper automatedTestCase : automatedTestCases) {
                        Object[] commaSeparatedValues;
                        for (String string : commaSeparatedValues = automatedTestCase.getKeyCustomFieldValues(this.keyCustomField)) {
                            if (caseResult.isSkipped() || !caseResult.getClassName().equals(string)) continue;
                            ExecutionStatus status = this.getExecutionStatus(caseResult);
                            automatedTestCase.addCustomFieldAndStatus(string, status);
                            if (this.isIncludeNotes()) {
                                String notes = this.getJUnitNotes(caseResult, build.number);
                                automatedTestCase.appendNotes(notes);
                            }
                            classNameTestCase.put(Integer.valueOf(automatedTestCase.getId()) + "#" + Arrays.toString(commaSeparatedValues), automatedTestCase);
                        }
                    }
                }
                for (Map.Entry entry : classNameTestCase.entrySet()) {
                    super.handleResult((TestCaseWrapper)entry.getValue(), build, listener, testlink, suiteResult);
                }
            }
        }
        catch (IOException e) {
            throw new ResultSeekerException(e);
        }
        catch (InterruptedException e) {
            throw new ResultSeekerException(e);
        }
    }

    private List<CaseResult> filter(List<CaseResult> cases) {
        LinkedList<CaseResult> filtered = new LinkedList<CaseResult>();
        for (CaseResult caseResult : cases) {
            CaseResult c = this.find(filtered, caseResult);
            if (c != null) {
                if (c.getFailCount() > 0) continue;
                this.remove(filtered, c);
                filtered.add(caseResult);
                continue;
            }
            filtered.add(caseResult);
        }
        return filtered;
    }

    private CaseResult find(List<CaseResult> filtered, CaseResult caseResult) {
        for (CaseResult c : filtered) {
            if (!c.getClassName().equals(caseResult.getClassName())) continue;
            return c;
        }
        return null;
    }

    private void remove(List<CaseResult> filtered, CaseResult caseResult) {
        Iterator<CaseResult> iterator = filtered.iterator();
        while (iterator.hasNext()) {
            CaseResult c = iterator.next();
            if (!c.getClassName().equals(caseResult.getClassName())) continue;
            iterator.remove();
        }
    }

    private ExecutionStatus getExecutionStatus(CaseResult caseResult) {
        if (caseResult.isSkipped()) {
            return ExecutionStatus.NOT_RUN;
        }
        if (caseResult.getFailCount() > 0) {
            return ExecutionStatus.FAILED;
        }
        return ExecutionStatus.PASSED;
    }

    private String getJUnitNotes(CaseResult testCase, int buildNumber) {
        StringBuilder notes = new StringBuilder();
        notes.append(Messages.Results_JUnit_NotesForTestClass(testCase.getClassName(), testCase.getSuiteResult() != null ? testCase.getSuiteResult().getTimestamp() : null));
        notes.append("\nBuild no : " + buildNumber);
        if (null != testCase.getErrorDetails()) {
            notes.append("\nError Message : " + testCase.getErrorDetails());
        }
        return notes.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ResultSeekerDescriptor {
        public String getDisplayName() {
            return "JUnit class name";
        }
    }
}

