/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import com.tupilabs.testng.parser.Suite;
import com.tupilabs.testng.parser.TestNGParser;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.ResultSeeker;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;

public abstract class AbstractTestNGResultSeeker
extends ResultSeeker {
    private static final long serialVersionUID = -1017414394764084125L;
    public static final String PASS = "PASS";
    public static final String FAIL = "FAIL";
    public static final String SKIP = "SKIP";
    public static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    protected transient TestNGParser _parser = null;
    private boolean attachTestNGXML = false;
    private boolean markSkippedTestAsBlocked = false;

    public AbstractTestNGResultSeeker(String includePattern, String keyCustomField, boolean attachTestNGXML, boolean markSkippedTestAsBlocked, boolean includeNotes) {
        super(includePattern, keyCustomField, includeNotes);
        this.attachTestNGXML = attachTestNGXML;
        this.markSkippedTestAsBlocked = markSkippedTestAsBlocked;
    }

    @Nonnull
    protected TestNGParser getParser() {
        if (this._parser == null) {
            this._parser = new TestNGParser();
        }
        return this._parser;
    }

    public void setAttachTestNGXML(boolean attachTestNGXML) {
        this.attachTestNGXML = attachTestNGXML;
    }

    public boolean isAttachTestNGXML() {
        return this.attachTestNGXML;
    }

    public void setMarkSkippedTestAsBlocked(boolean markSkippedTestAsBlocked) {
        this.markSkippedTestAsBlocked = markSkippedTestAsBlocked;
    }

    public boolean isMarkSkippedTestAsBlocked() {
        return this.markSkippedTestAsBlocked;
    }

    protected void handleResult(TestCaseWrapper automatedTestCase, AbstractBuild<?, ?> build, BuildListener listener, TestLinkSite testlink, ExecutionStatus status, final Suite suiteResult) {
        if (automatedTestCase.getExecutionStatus(this.keyCustomField) != ExecutionStatus.NOT_RUN) {
            try {
                int executionId = testlink.updateTestCase(automatedTestCase);
                if (executionId > 0 && this.isAttachTestNGXML()) {
                    Attachment attachment = (Attachment)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<Attachment>(){
                        private static final long serialVersionUID = -5411683541842375558L;

                        public Attachment invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                            File reportFile = new File(suiteResult.getFile());
                            Attachment attachment = new Attachment();
                            attachment.setContent(AbstractTestNGResultSeeker.this.getBase64FileContent(reportFile));
                            attachment.setDescription(reportFile.getName());
                            attachment.setFileName(reportFile.getName());
                            attachment.setFileSize(Long.valueOf(reportFile.length()));
                            attachment.setFileType(AbstractTestNGResultSeeker.TEXT_XML_CONTENT_TYPE);
                            attachment.setTitle(reportFile.getName());
                            return attachment;
                        }
                    });
                    testlink.uploadAttachment(executionId, attachment);
                }
            }
            catch (TestLinkAPIException te) {
                build.setResult(Result.UNSTABLE);
                te.printStackTrace(listener.getLogger());
            }
            catch (IOException e) {
                build.setResult(Result.UNSTABLE);
                e.printStackTrace(listener.getLogger());
            }
            catch (InterruptedException e) {
                build.setResult(Result.UNSTABLE);
                e.printStackTrace(listener.getLogger());
            }
        }
    }
}

