/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.plugins.testlink.Report;
import hudson.plugins.testlink.TestLinkBuildAction;
import hudson.plugins.testlink.TestLinkResult;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GraphHelper {
    private GraphHelper() {
    }

    public static void redirectWhenGraphUnsupported(StaplerResponse rsp, StaplerRequest req) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
    }

    public static JFreeChart createChart(StaplerRequest req, CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"TestLink Tests Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){
            private static final long serialVersionUID = 331915263367089058L;

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                return label.build.getNumber() + "/" + "testLinkResult";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                TestLinkBuildAction build = (TestLinkBuildAction)label.build.getAction(TestLinkBuildAction.class);
                TestLinkResult result = build.getResult();
                Report report = result.getReport();
                switch (row) {
                    case 0: {
                        return String.valueOf(report.getBlocked()) + " Blocked";
                    }
                    case 1: {
                        return String.valueOf(report.getFailed()) + " Failed";
                    }
                    case 2: {
                        return String.valueOf(report.getNotRun()) + " Not Run";
                    }
                    case 3: {
                        return String.valueOf(report.getPassed()) + " Passed";
                    }
                }
                return "";
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.YELLOW);
        ar.setSeriesPaint(1, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(2, (Paint)ColorPalette.GREY);
        ar.setSeriesPaint(3, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

