/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Extension;
import hudson.Launcher;
import hudson.console.HyperlinkNote;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Project;
import hudson.plugins.templateproject.TemplateUtils;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProxyBuilder
extends Builder
implements DependecyDeclarer {
    private final String projectName;

    @DataBoundConstructor
    public ProxyBuilder(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getExpandedProjectName(AbstractBuild<?, ?> build) {
        return TemplateUtils.getExpandedProjectName(this.projectName, build);
    }

    public AbstractProject<?, ?> getProject() {
        return TemplateUtils.getProject(this.projectName, null);
    }

    public List<Builder> getProjectBuilders(AbstractBuild<?, ?> build) {
        AbstractProject<?, ?> p = TemplateUtils.getProject(this.getProjectName(), build);
        if (p instanceof Project) {
            return ((Project)p).getBuilders();
        }
        if (p instanceof MatrixProject) {
            return ((MatrixProject)p).getBuilders();
        }
        return Collections.emptyList();
    }

    public void buildDependencyGraph(AbstractProject project, DependencyGraph graph) {
        AbstractProject templateProject = (AbstractProject)Hudson.getInstance().getItem(this.getProjectName());
        if (templateProject != null) {
            for (Publisher publisher : templateProject.getPublishersList().toList()) {
                if (!(publisher instanceof DependecyDeclarer)) continue;
                ((DependecyDeclarer)publisher).buildDependencyGraph(project, graph);
            }
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Builder builder : this.getProjectBuilders(build)) {
            AbstractProject<?, ?> p = TemplateUtils.getProject(this.getProjectName(), build);
            listener.getLogger().println("[TemplateProject] Starting builders from: " + HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getFullDisplayName()));
            if (!builder.perform(build, launcher, listener)) {
                listener.getLogger().println("[TemplateProject] FAILED performing builders from: '" + p.getFullDisplayName() + "'");
                return false;
            }
            listener.getLogger().println("[TemplateProject] Successfully performed builders from: '" + p.getFullDisplayName() + "'");
        }
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Builder builder : this.getProjectBuilders(build)) {
            if (builder.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList actions = new ArrayList();
        for (Builder builder : this.getProjectBuilders(null)) {
            actions.addAll(builder.getProjectActions(project));
        }
        return actions;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return "Use builders from another project";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckProjectName(@AncestorInPath AccessControlled anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Item item = Hudson.getInstance().getItemByFullName(value, Item.class);
            if (item == null) {
                return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName()));
            }
            if (!(item instanceof Project) && !(item instanceof MatrixProject)) {
                return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)value));
            }
            return FormValidation.ok();
        }
    }
}

