/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.JobProperty;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.plugins.templateproject.ProxyBuildEnvironment;
import hudson.plugins.templateproject.ProxyBuilder;
import hudson.plugins.templateproject.ProxyPublisher;
import hudson.plugins.templateproject.UpdateTransientProperty;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

@Extension
public class ItemListenerImpl
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ItemListenerImpl.class.getName());

    public void onLoaded() {
        for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
            if (project.getPublishersList().get(ProxyPublisher.class) == null && !this.hasBuilder(project, ProxyBuilder.class) && !this.hasBuildWrappers(project, ProxyBuildEnvironment.class)) continue;
            try {
                project.addProperty((JobProperty)new UpdateTransientProperty());
                project.removeProperty(UpdateTransientProperty.class);
            }
            catch (IOException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    private List<Builder> getBuilders(AbstractProject<?, ?> project) {
        if (project instanceof Project) {
            return ((Project)project).getBuilders();
        }
        if (project instanceof MatrixProject) {
            return ((MatrixProject)project).getBuilders();
        }
        return Collections.emptyList();
    }

    private List<BuildWrapper> getBuildWrappers(AbstractProject<?, ?> project) {
        if (project instanceof Project) {
            return ((Project)project).getBuildWrappersList();
        }
        if (project instanceof MatrixProject) {
            return ((MatrixProject)project).getBuildWrappersList();
        }
        return Collections.emptyList();
    }

    public <T> boolean hasBuilder(AbstractProject<?, ?> project, Class<T> type) {
        for (Builder b : this.getBuilders(project)) {
            if (!type.isInstance(b)) continue;
            return true;
        }
        return false;
    }

    public <T> boolean hasBuildWrappers(AbstractProject<?, ?> project, Class<T> type) {
        for (BuildWrapper b : this.getBuildWrappers(project)) {
            if (!type.isInstance(b)) continue;
            return true;
        }
        return false;
    }
}

