/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.coverity.CoverityVersion;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsException;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityRemoteCallable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;

public class ValidateCoverityInstallation
extends CoverityRemoteCallable<Boolean> {
    public static final CoverityVersion MINIMUM_SUPPORTED_VERSION = CoverityVersion.VERSION_PACIFIC;
    private static final long serialVersionUID = -460886461718309214L;
    private final String coverityToolHome;
    private final Boolean validateVersion;

    public ValidateCoverityInstallation(CoverityJenkinsIntLogger logger, Boolean validateVersion, String coverityToolHome) {
        super(logger);
        this.coverityToolHome = coverityToolHome;
        this.validateVersion = validateVersion;
    }

    public Boolean call() throws CoverityJenkinsException {
        Path pathToBinDirectory;
        Path pathToCoverityToolHome = Paths.get(this.coverityToolHome, new String[0]);
        if (!Files.exists(pathToCoverityToolHome, new LinkOption[0])) {
            throw new CoverityJenkinsException("The specified Analysis installation directory doesn't exist.");
        }
        if (Boolean.TRUE.equals(this.validateVersion)) {
            Path pathToAnalysisVersionFile = pathToCoverityToolHome.resolve("VERSION");
            Path pathToAnalysisVersionXml = pathToCoverityToolHome.resolve("VERSION.xml");
            if (Files.notExists(pathToAnalysisVersionXml, new LinkOption[0]) || Files.notExists(pathToAnalysisVersionFile, new LinkOption[0])) {
                throw new CoverityJenkinsException(String.format("%s and %s were not found.", pathToAnalysisVersionFile.toString(), pathToAnalysisVersionXml.toString()));
            }
            CoverityVersion coverityVersion = this.getVersion(pathToAnalysisVersionFile).orElse(null);
            if (coverityVersion == null) {
                throw new CoverityJenkinsException("Could not determine the version of the Coverity analysis tool.");
            }
            if (coverityVersion.compareTo(MINIMUM_SUPPORTED_VERSION) < 0) {
                throw new CoverityJenkinsException(String.format("Analysis version %s detected. The minimum supported version is %s", coverityVersion.toString(), MINIMUM_SUPPORTED_VERSION.toString()));
            }
        }
        if (!Files.isDirectory(pathToBinDirectory = pathToCoverityToolHome.resolve("bin"), new LinkOption[0])) {
            throw new CoverityJenkinsException(String.format("%s was not found", pathToBinDirectory.toString()));
        }
        return true;
    }

    private Optional<CoverityVersion> getVersion(Path versionFile) throws CoverityJenkinsException {
        Optional<CoverityVersion> optional;
        block8: {
            String versionPrefix = "externalVersion=";
            Stream<String> lines = Files.lines(versionFile);
            try {
                optional = lines.filter(str -> str.startsWith("externalVersion=")).map(str -> str.substring("externalVersion=".length())).map(CoverityVersion::parse).filter(Optional::isPresent).map(Optional::get).findFirst();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CoverityJenkinsException("Could not validate the version of the COVERITY_TOOL_HOME", e);
                }
            }
            lines.close();
        }
        return optional;
    }
}

