/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.JenkinsCoverityEnvironmentVariable;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsException;
import com.synopsys.integration.jenkins.coverity.extensions.OnCommandFailure;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityRemoteToolRunner;
import com.synopsys.integration.stepworkflow.AbstractConsumingSubStep;
import com.synopsys.integration.stepworkflow.SubStepResponse;
import com.synopsys.integration.util.IntEnvironmentVariables;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class RunCoverityCommands
extends AbstractConsumingSubStep<List<List<String>>> {
    private final CoverityJenkinsIntLogger logger;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final String remoteWorkingDirectory;
    private final OnCommandFailure onCommandFailure;
    private final VirtualChannel virtualChannel;

    public RunCoverityCommands(CoverityJenkinsIntLogger logger, IntEnvironmentVariables intEnvironmentVariables, String remoteWorkingDirectory, OnCommandFailure onCommandFailure, VirtualChannel virtualChannel) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.remoteWorkingDirectory = remoteWorkingDirectory;
        this.onCommandFailure = onCommandFailure;
        this.virtualChannel = virtualChannel;
    }

    public SubStepResponse<Object> run(List<List<String>> commands) {
        try {
            boolean oneOrMoreCommandsFailed = false;
            for (List<String> arguments : commands) {
                CoverityRemoteToolRunner coverityRemoteToolRunner;
                Integer exitCode;
                if (arguments.isEmpty() || (exitCode = (Integer)this.virtualChannel.call((Callable)(coverityRemoteToolRunner = new CoverityRemoteToolRunner(this.logger, this.intEnvironmentVariables.getValue(JenkinsCoverityEnvironmentVariable.COVERITY_TOOL_HOME.toString()), arguments, this.remoteWorkingDirectory, (HashMap)this.intEnvironmentVariables.getVariables())))) == null || exitCode == 0) continue;
                String exitCodeErrorMessage = "Coverity failed with exit code: " + exitCode;
                if (OnCommandFailure.SKIP_REMAINING_COMMANDS.equals((Object)this.onCommandFailure)) {
                    throw new CoverityJenkinsException(exitCodeErrorMessage);
                }
                oneOrMoreCommandsFailed = true;
                this.logger.error(exitCodeErrorMessage);
            }
            if (oneOrMoreCommandsFailed) {
                throw new CoverityJenkinsException("One or more Coverity commands failed");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return SubStepResponse.FAILURE((Exception)e);
        }
        catch (IntegrationException | IOException e) {
            return SubStepResponse.FAILURE((Exception)e);
        }
        return SubStepResponse.SUCCESS();
    }
}

