/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.coverity.api.rest.View;
import com.synopsys.integration.coverity.api.rest.ViewContents;
import com.synopsys.integration.coverity.api.ws.configuration.CovRemoteServiceException_Exception;
import com.synopsys.integration.coverity.api.ws.configuration.ProjectDataObj;
import com.synopsys.integration.coverity.ws.ConfigurationServiceWrapper;
import com.synopsys.integration.coverity.ws.view.ViewReportWrapper;
import com.synopsys.integration.coverity.ws.view.ViewService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.stepworkflow.AbstractSupplyingSubStep;
import com.synopsys.integration.stepworkflow.SubStepResponse;
import hudson.AbortException;
import java.io.IOException;

public class GetIssuesInView
extends AbstractSupplyingSubStep<ViewReportWrapper> {
    private final ConfigurationServiceWrapper configurationServiceWrapper;
    private final ViewService viewService;
    private final String projectName;
    private final String viewName;
    private final CoverityJenkinsIntLogger logger;

    public GetIssuesInView(CoverityJenkinsIntLogger logger, ConfigurationServiceWrapper configurationServiceWrapper, ViewService viewService, String projectName, String viewName) {
        this.logger = logger;
        this.configurationServiceWrapper = configurationServiceWrapper;
        this.viewService = viewService;
        this.projectName = projectName;
        this.viewName = viewName;
    }

    public SubStepResponse<ViewReportWrapper> run() {
        try {
            this.logger.alwaysLog(String.format("Checking for issues in project \"%s\", view \"%s\".", this.projectName, this.viewName));
            ProjectDataObj project = (ProjectDataObj)this.configurationServiceWrapper.getProjectByExactName(this.projectName).orElseThrow(() -> new AbortException("Coverity Issues could not be retrieved: No project with name " + this.projectName + " could be found. It either does not exist or the credentials configured in the Jenkins system configuration are insufficient to access it."));
            View view = (View)this.viewService.getViewByExactName(this.viewName).orElseThrow(() -> new AbortException("Coverity Issues could not be retrieved: No view with name " + this.viewName + " could be found. It either does not exist or the credentials configured in the Jenkins system configuration are insufficient to access it."));
            ViewContents viewContents = this.viewService.getViewContents(project, view, 1, 0);
            String viewReportUrl = this.viewService.getProjectViewReportUrl(project, view);
            ViewReportWrapper viewReportWrapper = new ViewReportWrapper(viewContents, viewReportUrl);
            return SubStepResponse.SUCCESS((Object)viewReportWrapper);
        }
        catch (CovRemoteServiceException_Exception | IntegrationException | IOException e) {
            return SubStepResponse.FAILURE((Exception)e);
        }
    }
}

