/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.coverity.api.ws.configuration.CovRemoteServiceException_Exception;
import com.synopsys.integration.coverity.api.ws.configuration.ProjectDataObj;
import com.synopsys.integration.coverity.ws.ConfigurationServiceWrapper;
import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import com.synopsys.integration.stepworkflow.AbstractExecutingSubStep;
import com.synopsys.integration.stepworkflow.SubStepResponse;
import java.util.Optional;

public class CreateMissingProjectsAndStreams
extends AbstractExecutingSubStep {
    private final JenkinsIntLogger logger;
    private final ConfigurationServiceWrapper configurationServiceWrapper;
    private final String projectName;
    private final String streamName;

    public CreateMissingProjectsAndStreams(JenkinsIntLogger logger, ConfigurationServiceWrapper configurationServiceWrapper, String projectName, String streamName) {
        this.logger = logger;
        this.configurationServiceWrapper = configurationServiceWrapper;
        this.projectName = projectName;
        this.streamName = streamName;
    }

    public SubStepResponse<Object> run() {
        try {
            Optional matchingStream;
            Optional matchingProject = this.configurationServiceWrapper.getProjectByExactName(this.projectName);
            if (!matchingProject.isPresent()) {
                this.logger.info(String.format("No project with the name '%s' was found, attempting creation...", this.projectName));
                this.configurationServiceWrapper.createSimpleProject(this.projectName);
                matchingProject = this.configurationServiceWrapper.getAndWaitForProjectWithExactName(this.projectName);
                if (matchingProject.isPresent()) {
                    this.logger.info(String.format("Successfully created project '%s'", this.projectName));
                } else {
                    this.logger.error(String.format("Could not create project '%s'", this.projectName));
                }
            }
            if (!(matchingStream = this.configurationServiceWrapper.getStreamByExactName(this.streamName)).isPresent() && matchingProject.isPresent()) {
                this.logger.info(String.format("No stream with the name '%s' was found, attempting creation as an Any language stream with the Default Triage Store in project '%s'...", this.streamName, this.projectName));
                this.configurationServiceWrapper.createSimpleStreamInProject(((ProjectDataObj)matchingProject.get()).getId(), this.streamName);
                matchingStream = this.configurationServiceWrapper.getAndWaitForStreamWithExactName(this.streamName);
                if (matchingStream.isPresent()) {
                    this.logger.info(String.format("Successfully created stream '%s'", this.streamName));
                } else {
                    this.logger.error(String.format("Could not create stream '%s'", this.streamName));
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return SubStepResponse.FAILURE((Exception)e);
        }
        catch (CovRemoteServiceException_Exception e) {
            return SubStepResponse.FAILURE((Exception)((Object)e));
        }
        return SubStepResponse.SUCCESS();
    }
}

