/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.coverity.exception.ExecutableException;
import com.synopsys.integration.coverity.exception.ExecutableRunnerException;
import com.synopsys.integration.coverity.executable.Executable;
import com.synopsys.integration.coverity.executable.ExecutableManager;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsException;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityRemoteCallable;
import com.synopsys.integration.log.IntLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;

public class CoverityRemoteToolRunner
extends CoverityRemoteCallable<Integer> {
    private static final long serialVersionUID = -1777043273065180425L;
    private final String coverityToolHome;
    private final List<String> arguments;
    private final HashMap<String, String> environmentVariables;
    private final String workingDirectoryPath;

    public CoverityRemoteToolRunner(CoverityJenkinsIntLogger logger, String coverityToolHome, List<String> arguments, String workingDirectoryPath, HashMap<String, String> environmentVariables) {
        super(logger);
        this.environmentVariables = environmentVariables;
        this.coverityToolHome = coverityToolHome;
        this.arguments = arguments;
        this.workingDirectoryPath = workingDirectoryPath;
    }

    public Integer call() throws CoverityJenkinsException {
        Integer exitCode;
        File workingDirectory = new File(this.workingDirectoryPath);
        Executable executable = new Executable(this.arguments, workingDirectory, this.environmentVariables);
        ExecutableManager executableManager = new ExecutableManager(new File(this.coverityToolHome));
        ByteArrayOutputStream errorOutputStream = new ByteArrayOutputStream();
        try (PrintStream errorStream = new PrintStream((OutputStream)errorOutputStream, true, "UTF-8");){
            PrintStream jenkinsPrintStream = this.logger.getTaskListener().getLogger();
            exitCode = executableManager.execute(executable, (IntLogger)this.logger, jenkinsPrintStream, errorStream);
        }
        catch (ExecutableException | ExecutableRunnerException | UnsupportedEncodingException e) {
            throw new CoverityJenkinsException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CoverityJenkinsException(e);
        }
        finally {
            this.logger.error(new String(errorOutputStream.toByteArray(), StandardCharsets.UTF_8));
        }
        return exitCode;
    }
}

