/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.coverity.api.ws.configuration.ConfigurationService;
import com.synopsys.integration.coverity.api.ws.configuration.LicenseDataObj;
import com.synopsys.integration.coverity.api.ws.configuration.VersionDataObj;
import com.synopsys.integration.coverity.config.CoverityHttpClient;
import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.function.ThrowingSupplier;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.phonehome.request.PhoneHomeRequestBodyBuilder;
import com.synopsys.integration.stepworkflow.StepWorkflowResponse;
import com.synopsys.integration.stepworkflow.jenkins.JenkinsStepWorkflow;
import hudson.AbortException;
import java.net.MalformedURLException;

public abstract class CoverityJenkinsStepWorkflow<T>
extends JenkinsStepWorkflow<T> {
    protected final ThrowingSupplier<WebServiceFactory, CoverityJenkinsAbortException> webServiceFactorySupplier;
    protected WebServiceFactory webServiceFactory;

    public CoverityJenkinsStepWorkflow(JenkinsIntLogger logger, JenkinsVersionHelper jenkinsVersionHelper, ThrowingSupplier<WebServiceFactory, CoverityJenkinsAbortException> webServiceFactorySupplier) {
        super(logger, jenkinsVersionHelper);
        this.webServiceFactorySupplier = webServiceFactorySupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepWorkflowResponse<T> runWorkflow() throws AbortException {
        Thread thread = Thread.currentThread();
        ClassLoader threadClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.webServiceFactory = (WebServiceFactory)this.webServiceFactorySupplier.get();
            StepWorkflowResponse stepWorkflowResponse = super.runWorkflow();
            return stepWorkflowResponse;
        }
        finally {
            this.cleanUp();
            thread.setContextClassLoader(threadClassLoader);
        }
    }

    protected abstract void cleanUp() throws AbortException;

    protected PhoneHomeRequestBodyBuilder createPhoneHomeBuilder() {
        String cimVersion;
        String customerName;
        CoverityHttpClient coverityHttpClient = this.webServiceFactory.getCoverityHttpClient();
        try {
            ConfigurationService configurationService = this.webServiceFactory.createConfigurationService();
            try {
                LicenseDataObj licenseDataObj = configurationService.getLicenseConfiguration();
                customerName = licenseDataObj.getCustomer();
            }
            catch (Exception e) {
                this.logger.trace("Couldn't get the Coverity customer id: " + e.getMessage());
                customerName = "<unknown>";
            }
            try {
                VersionDataObj versionDataObj = configurationService.getVersion();
                cimVersion = versionDataObj.getExternalVersion();
            }
            catch (Exception e) {
                this.logger.trace("Couldn't get the Coverity version: " + e.getMessage());
                cimVersion = "<unknown>";
            }
        }
        catch (MalformedURLException e) {
            this.logger.trace("Couldn't get the Coverity customer id: " + e.getMessage());
            this.logger.trace("Couldn't get the Coverity version: " + e.getMessage());
            cimVersion = "<unknown>";
            customerName = "<unknown>";
        }
        String pluginVersion = this.jenkinsVersionHelper.getPluginVersion("synopsys-coverity").orElse("<unknown>");
        return PhoneHomeRequestBodyBuilder.createForCoverity((String)"synopsys-coverity", (String)customerName, (String)coverityHttpClient.getBaseUrl(), (String)pluginVersion, (String)cimVersion);
    }
}

