/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import hudson.FilePath;
import java.io.IOException;

public class CleanUpWorkflowService {
    private final JenkinsIntLogger logger;

    public CleanUpWorkflowService(JenkinsIntLogger logger) {
        this.logger = logger;
    }

    public void cleanUpIntermediateDirectory(FilePath intermediateDirectory) {
        try {
            intermediateDirectory.deleteRecursive();
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.logger.warn("WARNING: Synopsys Coverity for Jenkins could not clean up the intermediary directory.");
            this.logger.trace("Synopsys Coverity for Jenkins could not clean up the intermediary directory because: ", (Throwable)e);
        }
    }

    public void cleanUpAuthenticationFile(FilePath authenticationKeyFile) {
        try {
            if (authenticationKeyFile.delete()) {
                this.logger.debug("Authentication keyfile deleted successfully");
            } else {
                this.logger.warn("WARNING: Synopsys Coverity for Jenkins could not clean up the authentication key file. It may have been cleaned up by something else.");
            }
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.logger.error("ERROR: Synopsys Coverity for Jenkins could not clean up authentication file because: ", (Throwable)e);
        }
    }
}

