/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.wrap;

import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.function.ThrowingSupplier;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.coverity.extensions.ConfigureChangeSetPatterns;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityJenkinsStepWorkflow;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityWorkflowStepFactory;
import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.stepworkflow.StepWorkflow;
import com.synopsys.integration.stepworkflow.StepWorkflowResponse;
import com.synopsys.integration.stepworkflow.SubStep;
import hudson.AbortException;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.util.List;
import jenkins.tasks.SimpleBuildWrapper;

public class CoverityEnvironmentWrapperStepWorkflow
extends CoverityJenkinsStepWorkflow<Object> {
    public static final String FAILURE_MESSAGE = "Unable to inject Coverity Environment: ";
    private final CoverityWorkflowStepFactory coverityWorkflowStepFactory;
    private final SimpleBuildWrapper.Context context;
    private final String workspaceRemotePath;
    private final String coverityInstanceUrl;
    private final String credentialsId;
    private final String projectName;
    private final String streamName;
    private final String viewName;
    private final Boolean createMissingProjectsAndStreams;
    private final List<ChangeLogSet<?>> changeSets;
    private final ConfigureChangeSetPatterns configureChangeSetPatterns;

    public CoverityEnvironmentWrapperStepWorkflow(JenkinsIntLogger jenkinsIntLogger, JenkinsVersionHelper jenkinsVersionHelper, ThrowingSupplier<WebServiceFactory, CoverityJenkinsAbortException> webServiceFactorySupplier, CoverityWorkflowStepFactory coverityWorkflowStepFactory, SimpleBuildWrapper.Context context, String workspaceRemotePath, String coverityInstanceUrl, String credentialsId, String projectName, String streamName, String viewName, Boolean createMissingProjectsAndStreams, List<ChangeLogSet<?>> changeSets, ConfigureChangeSetPatterns configureChangeSetPatterns) {
        super(jenkinsIntLogger, jenkinsVersionHelper, webServiceFactorySupplier);
        this.coverityWorkflowStepFactory = coverityWorkflowStepFactory;
        this.context = context;
        this.workspaceRemotePath = workspaceRemotePath;
        this.coverityInstanceUrl = coverityInstanceUrl;
        this.credentialsId = credentialsId;
        this.projectName = projectName;
        this.streamName = streamName;
        this.viewName = viewName;
        this.createMissingProjectsAndStreams = createMissingProjectsAndStreams;
        this.changeSets = changeSets;
        this.configureChangeSetPatterns = configureChangeSetPatterns;
    }

    protected StepWorkflow<Object> buildWorkflow() throws AbortException {
        return StepWorkflow.first(this.coverityWorkflowStepFactory.createStepValidateCoverityInstallation(false)).then(this.coverityWorkflowStepFactory.createStepCreateAuthenticationKeyFile(this.workspaceRemotePath, this.coverityInstanceUrl, this.credentialsId)).then((SubStep)this.coverityWorkflowStepFactory.createStepSetUpCoverityEnvironment(this.changeSets, this.configureChangeSetPatterns, this.workspaceRemotePath, this.coverityInstanceUrl, this.credentialsId, this.projectName, this.streamName, this.viewName)).then(this.coverityWorkflowStepFactory.createStepPopulateEnvVars((arg_0, arg_1) -> ((SimpleBuildWrapper.Context)this.context).env(arg_0, arg_1))).andSometimes((SubStep)this.coverityWorkflowStepFactory.createStepCreateMissingProjectsAndStreams(this.coverityInstanceUrl, this.credentialsId, this.projectName, this.streamName)).butOnlyIf((Object)this.createMissingProjectsAndStreams, Boolean.TRUE::equals).build();
    }

    public Boolean perform() throws IOException {
        StepWorkflowResponse response = this.runWorkflow();
        try {
            if (!response.wasSuccessful()) {
                throw response.getException();
            }
        }
        catch (IntegrationException e) {
            this.logger.debug(null, (Throwable)e);
            throw new AbortException(FAILURE_MESSAGE + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException(FAILURE_MESSAGE + e.getMessage(), e);
        }
        return response.wasSuccessful();
    }

    @Override
    protected void cleanUp() throws AbortException {
    }
}

