/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.wrap;

import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.function.ThrowingSupplier;
import com.synopsys.integration.jenkins.PasswordMaskingOutputStream;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.GlobalValueHelper;
import com.synopsys.integration.jenkins.coverity.JenkinsCoverityEnvironmentVariable;
import com.synopsys.integration.jenkins.coverity.SynopsysCoverityCredentialsHelper;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.coverity.extensions.ConfigureChangeSetPatterns;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.utils.CoverityConnectionFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.utils.IssueViewFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.utils.ProjectStreamFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.wrap.CoverityEnvironmentWrapperStepWorkflow;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CleanUpWorkflowService;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityWorkflowStepFactory;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.SilentIntLogger;
import com.synopsys.integration.log.Slf4jIntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.tasks.SimpleBuildWrapper;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.LoggerFactory;

public class CoverityEnvironmentWrapper
extends SimpleBuildWrapper {
    public static final String FIELD_COVERITY_INSTANCE_URL = "coverityInstanceUrl";
    public static final String FIELD_PROJECT_NAME = "projectName";
    public static final String FIELD_STREAM_NAME = "streamName";
    public static final String NESTED_DESCRIPTOR_CHECK_FOR_ISSUES = "checkForIssuesInView";
    public static final String NESTED_DESCRIPTOR_CONFIGURE_CHANGE_SET_PATTERNS = "configureChangeSetPatterns";
    public static final String NESTED_DESCRIPTOR_COVERITY_RUN_CONFIGURATION = "coverityRunConfiguration";
    public static final String FIELD_ON_COMMAND_FAILURE = "onCommandFailure";
    public static final String FIELD_CLEAN_UP_ACTION = "cleanUpAction";
    public static final String FIELD_CREDENTIALS_ID = "credentialsId";
    private final String coverityInstanceUrl;
    private final String coverityPassphrase;
    @Nullable
    private String projectName;
    @Nullable
    private String streamName;
    @Nullable
    private String viewName;
    @Nullable
    private ConfigureChangeSetPatterns configureChangeSetPatterns;
    @Nullable
    private Boolean createMissingProjectsAndStreams;
    @Nullable
    private String credentialsId;

    @DataBoundConstructor
    public CoverityEnvironmentWrapper(String coverityInstanceUrl) {
        this.coverityInstanceUrl = coverityInstanceUrl;
        this.coverityPassphrase = GlobalValueHelper.getCoverityInstanceWithUrl((IntLogger)new SilentIntLogger(), coverityInstanceUrl).flatMap(coverityConnectInstance -> coverityConnectInstance.getPassphrase(this.credentialsId)).orElse("");
    }

    public Boolean getCreateMissingProjectsAndStreams() {
        if (Boolean.FALSE.equals(this.createMissingProjectsAndStreams)) {
            return null;
        }
        return this.createMissingProjectsAndStreams;
    }

    @DataBoundSetter
    public void setCreateMissingProjectsAndStreams(@QueryParameter(value="createMissingProjectsAndStreams") Boolean createMissingProjectsAndStreams) {
        this.createMissingProjectsAndStreams = createMissingProjectsAndStreams;
    }

    public String getCoverityInstanceUrl() {
        return this.coverityInstanceUrl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(@QueryParameter(value="projectName") String projectName) {
        this.projectName = projectName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    @DataBoundSetter
    public void setStreamName(@QueryParameter(value="streamName") String streamName) {
        this.streamName = streamName;
    }

    public String getViewName() {
        return this.viewName;
    }

    @DataBoundSetter
    public void setViewName(@QueryParameter(value="viewName") String viewName) {
        this.viewName = viewName;
    }

    public ConfigureChangeSetPatterns getConfigureChangeSetPatterns() {
        return this.configureChangeSetPatterns;
    }

    @DataBoundSetter
    public void setConfigureChangeSetPatterns(@QueryParameter(value="configureChangeSetPatterns") ConfigureChangeSetPatterns configureChangeSetPatterns) {
        this.configureChangeSetPatterns = configureChangeSetPatterns;
    }

    public String getCredentialsId() {
        if (StringUtils.isNotBlank((CharSequence)this.credentialsId)) {
            return this.credentialsId;
        }
        return null;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        String resolvedCredentialsId;
        List<ChangeLogSet<?>> changeLogSets;
        Node node = Optional.ofNullable(workspace.toComputer()).map(Computer::getNode).orElse(null);
        RunWrapper runWrapper = new RunWrapper(build, true);
        CoverityWorkflowStepFactory coverityWorkflowStepFactory = new CoverityWorkflowStepFactory(initialEnvironment, node, launcher, listener);
        CoverityJenkinsIntLogger logger = coverityWorkflowStepFactory.getOrCreateLogger();
        JenkinsVersionHelper jenkinsVersionHelper = JenkinsWrapper.initializeFromJenkinsJVM().getVersionHelper();
        try {
            changeLogSets = runWrapper.getChangeSets();
        }
        catch (Exception e) {
            logger.warn(String.format("WARNING: Synopsys Coverity for Jenkins could not determine the change set, %s will be empty and %s will be 0.", new Object[]{JenkinsCoverityEnvironmentVariable.CHANGE_SET, JenkinsCoverityEnvironmentVariable.CHANGE_SET_SIZE}));
            changeLogSets = Collections.emptyList();
        }
        if (this.credentialsId != null) {
            resolvedCredentialsId = this.credentialsId;
        } else {
            CoverityConnectInstance coverityConnectInstance = coverityWorkflowStepFactory.getCoverityConnectInstanceFromUrl(this.coverityInstanceUrl);
            resolvedCredentialsId = coverityConnectInstance.getDefaultCredentialsId();
        }
        CoverityEnvironmentWrapperStepWorkflow coverityEnvironmentWrapperStepWorkflow = new CoverityEnvironmentWrapperStepWorkflow(logger, jenkinsVersionHelper, (ThrowingSupplier<WebServiceFactory, CoverityJenkinsAbortException>)((ThrowingSupplier)() -> coverityWorkflowStepFactory.getWebServiceFactoryFromUrl(this.coverityInstanceUrl, resolvedCredentialsId)), coverityWorkflowStepFactory, context, workspace.getRemote(), this.coverityInstanceUrl, resolvedCredentialsId, this.projectName, this.streamName, this.viewName, this.createMissingProjectsAndStreams, changeLogSets, this.configureChangeSetPatterns);
        Boolean environmentInjectedSuccessfully = coverityEnvironmentWrapperStepWorkflow.perform();
        if (Boolean.TRUE.equals(environmentInjectedSuccessfully)) {
            logger.info("Coverity environment injected successfully.");
        }
        context.setDisposer((SimpleBuildWrapper.Disposer)new DisposerImpl((HashMap)coverityWorkflowStepFactory.getOrCreateEnvironmentVariables().getVariables()));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public ConsoleLogFilter createLoggerDecorator(@Nonnull Run<?, ?> build) {
        return new FilterImpl(this.coverityPassphrase);
    }

    private static final class DisposerImpl
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 4771346213830683656L;
        private final HashMap<String, String> environmentVariables;

        public DisposerImpl(HashMap<String, String> intEnvironmentVariables) {
            this.environmentVariables = intEnvironmentVariables;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            IntEnvironmentVariables intEnvironmentVariables = IntEnvironmentVariables.empty();
            intEnvironmentVariables.putAll(this.environmentVariables);
            CoverityJenkinsIntLogger logger = CoverityJenkinsIntLogger.initializeLogger(listener, intEnvironmentVariables);
            CleanUpWorkflowService cleanUpWorkflowService = new CleanUpWorkflowService(logger);
            String authKeyPath = intEnvironmentVariables.getValue(JenkinsCoverityEnvironmentVariable.TEMPORARY_AUTH_KEY_PATH.toString());
            if (StringUtils.isNotBlank((CharSequence)authKeyPath)) {
                FilePath authKeyFile = new FilePath(launcher.getChannel(), authKeyPath);
                cleanUpWorkflowService.cleanUpAuthenticationFile(authKeyFile);
            }
        }
    }

    private static final class FilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1787519634824445328L;
        private final String passwordToMask;

        public FilterImpl(String passwordToMask) {
            this.passwordToMask = passwordToMask;
        }

        public OutputStream decorateLogger(Run ignored, OutputStream logger) {
            return new PasswordMaskingOutputStream(logger, this.passwordToMask);
        }
    }

    @Symbol(value={"withCoverityEnvironment"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private final CoverityConnectionFieldHelper coverityConnectionFieldHelper;
        private final ProjectStreamFieldHelper projectStreamFieldHelper;
        private final SynopsysCoverityCredentialsHelper credentialsHelper;
        private final IssueViewFieldHelper issueViewFieldHelper;

        public DescriptorImpl() {
            super(CoverityEnvironmentWrapper.class);
            this.load();
            Slf4jIntLogger slf4jIntLogger = new Slf4jIntLogger(LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
            this.coverityConnectionFieldHelper = new CoverityConnectionFieldHelper((IntLogger)slf4jIntLogger);
            this.projectStreamFieldHelper = new ProjectStreamFieldHelper((IntLogger)slf4jIntLogger);
            this.issueViewFieldHelper = new IssueViewFieldHelper((IntLogger)slf4jIntLogger);
            this.credentialsHelper = new SynopsysCoverityCredentialsHelper((IntLogger)slf4jIntLogger, JenkinsWrapper.initializeFromJenkinsJVM());
        }

        @POST
        public ListBoxModel doFillCoverityInstanceUrlItems(@AncestorInPath Item item) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doFillCoverityInstanceUrlItems();
        }

        @POST
        public FormValidation doCheckCoverityInstanceUrl(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrl(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.credentialsHelper.listSupportedCredentials();
        }

        @POST
        public ComboBoxModel doFillProjectNameItems(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="updateNow") boolean updateNow) throws InterruptedException {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            if (updateNow) {
                this.projectStreamFieldHelper.updateNow(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
            }
            return this.projectStreamFieldHelper.getProjectNamesForComboBox(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrlIgnoreMessage(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public ComboBoxModel doFillStreamNameItems(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="projectName") String projectName) throws InterruptedException {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.projectStreamFieldHelper.getStreamNamesForComboBox(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId, projectName);
        }

        @POST
        public FormValidation doCheckStreamName(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrlIgnoreMessage(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public ListBoxModel doFillViewNameItems(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="updateNow") boolean updateNow) throws InterruptedException {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            if (updateNow) {
                this.issueViewFieldHelper.updateNow(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
            }
            return this.issueViewFieldHelper.getViewNamesForListBox(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public FormValidation doCheckViewName(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrl(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Inject Coverity environment into the build process";
        }
    }
}

