/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.utils;

import com.synopsys.integration.coverity.config.CoverityServerConfig;
import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.log.IntLogger;
import java.time.Instant;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class CoverityConnectDataCache<T> {
    public static final int CACHE_TIME_IN_MINUTES = 5;
    protected final IntLogger logger;
    private final Semaphore semaphore;
    private Instant lastTimeRetrieved;
    private T cachedData;

    public CoverityConnectDataCache(IntLogger logger) {
        this.logger = logger;
        this.semaphore = new Semaphore(1);
        this.lastTimeRetrieved = Instant.MIN;
        this.cachedData = this.getEmptyData();
    }

    public T getData(CoverityConnectInstance coverityConnectInstance, String credentialsId) throws InterruptedException {
        this.semaphore.acquire();
        this.semaphore.release();
        this.refreshIfStale(coverityConnectInstance, credentialsId);
        return this.cachedData;
    }

    public void refreshIfStale(CoverityConnectInstance coverityConnectInstance, String credentialsId) throws InterruptedException {
        long cacheTimeInSeconds = TimeUnit.MINUTES.toSeconds(5L);
        if (Instant.now().minusSeconds(cacheTimeInSeconds).isAfter(this.lastTimeRetrieved)) {
            this.refresh(coverityConnectInstance, credentialsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(CoverityConnectInstance coverityConnectInstance, String credentialsId) throws InterruptedException {
        this.semaphore.acquire();
        Thread thread = Thread.currentThread();
        ClassLoader threadClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.logger.info("Refreshing connection to Coverity Connect instance...");
            CoverityServerConfig coverityServerConfig = coverityConnectInstance.getCoverityServerConfig(this.logger, credentialsId);
            WebServiceFactory webServiceFactory = coverityServerConfig.createWebServiceFactory(this.logger);
            webServiceFactory.connect();
            this.cachedData = this.getFreshData(webServiceFactory);
            this.lastTimeRetrieved = Instant.now();
            this.logger.info("Connection refreshed successfully.");
        }
        catch (Exception e) {
            this.logger.error("[ERROR] Could not refresh connection to Coverity Connect instance. Please confirm you have a valid URL.");
            this.logger.trace("Stack trace:", (Throwable)e);
        }
        finally {
            thread.setContextClassLoader(threadClassLoader);
            this.semaphore.release();
        }
    }

    protected abstract T getFreshData(WebServiceFactory var1);

    protected abstract T getEmptyData();
}

