/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.utils;

import com.synopsys.integration.coverity.exception.CoverityIntegrationException;
import com.synopsys.integration.jenkins.coverity.GlobalValueHelper;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.utils.CoverityConnectDataCache;
import com.synopsys.integration.jenkins.coverity.extensions.utils.FieldHelper;
import com.synopsys.integration.log.IntLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public abstract class ConnectionCachingFieldHelper<T extends CoverityConnectDataCache>
extends FieldHelper {
    private final ConcurrentHashMap<List<String>, T> cacheMap = new ConcurrentHashMap();
    private final Supplier<T> cacheConstructor;

    public ConnectionCachingFieldHelper(IntLogger logger, Supplier<T> cacheConstructor) {
        super(logger);
        this.cacheConstructor = cacheConstructor;
    }

    public void updateNow(String coverityConnectUrl, Boolean overrideDefaultCredentials, String credentialsId) throws InterruptedException {
        try {
            CoverityConnectInstance coverityConnectInstance = GlobalValueHelper.getCoverityInstanceWithUrlOrDie(this.logger, coverityConnectUrl);
            if (Boolean.TRUE.equals(overrideDefaultCredentials)) {
                T cache = this.getCache(coverityConnectUrl, credentialsId);
                ((CoverityConnectDataCache)cache).refresh(coverityConnectInstance, credentialsId);
            } else {
                T cache = this.getCache(coverityConnectUrl, coverityConnectInstance.getDefaultCredentialsId());
                ((CoverityConnectDataCache)cache).refresh(coverityConnectInstance, coverityConnectInstance.getDefaultCredentialsId());
            }
        }
        catch (CoverityIntegrationException coverityIntegrationException) {
            // empty catch block
        }
    }

    protected T getCache(String coverityConnectUrl, String credentialsId) {
        List<String> urlAndCredentialsId = Collections.unmodifiableList(Arrays.asList(coverityConnectUrl, credentialsId));
        this.cacheMap.putIfAbsent(urlAndCredentialsId, (CoverityConnectDataCache)this.cacheConstructor.get());
        return (T)((CoverityConnectDataCache)this.cacheMap.get(urlAndCredentialsId));
    }
}

