/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.pipeline;

import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.function.ThrowingSupplier;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.JenkinsCoverityEnvironmentVariable;
import com.synopsys.integration.jenkins.coverity.SynopsysCoverityCredentialsHelper;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.pipeline.CheckForIssuesStepWorkflow;
import com.synopsys.integration.jenkins.coverity.extensions.utils.CoverityConnectionFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.utils.IssueViewFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.utils.ProjectStreamFieldHelper;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityWorkflowStepFactory;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.Slf4jIntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.LoggerFactory;

public class CheckForIssuesStep
extends Step
implements Serializable {
    public static final String DISPLAY_NAME = "Check for Issues in Coverity View";
    public static final String PIPELINE_NAME = "coverityIssueCheck";
    private static final long serialVersionUID = 3602102048550370960L;
    public static final String FIELD_COVERITY_INSTANCE_URL = "coverityInstanceUrl";
    public static final String FIELD_PROJECT_NAME = "projectName";
    public static final String FIELD_STREAM_NAME = "streamName";
    public static final String FIELD_VIEW_NAME = "viewName";
    public static final String FIELD_CREDENTIALS_ID = "credentialsId";
    public static final String FIELD_RETURN_ISSUE_COUNT = "returnIssueCount";
    public static final String FIELD_MARK_UNSTABLE = "markUnstable";
    @Nullable
    private String coverityInstanceUrl;
    @Nullable
    private String credentialsId;
    @Nullable
    private String projectName;
    @Nullable
    private String viewName;
    @Nullable
    private Boolean returnIssueCount;
    @Nullable
    private Boolean markUnstable;

    @DataBoundConstructor
    public CheckForIssuesStep() {
    }

    public String getCredentialsId() {
        if (StringUtils.isNotBlank((CharSequence)this.credentialsId)) {
            return this.credentialsId;
        }
        return null;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public Boolean getReturnIssueCount() {
        if (Boolean.FALSE.equals(this.returnIssueCount)) {
            return null;
        }
        return this.returnIssueCount;
    }

    @DataBoundSetter
    public void setReturnIssueCount(Boolean returnIssueCount) {
        this.returnIssueCount = returnIssueCount;
    }

    public String getCoverityInstanceUrl() {
        if (StringUtils.isBlank((CharSequence)this.coverityInstanceUrl)) {
            return null;
        }
        return this.coverityInstanceUrl;
    }

    @DataBoundSetter
    public void setCoverityInstanceUrl(String coverityInstanceUrl) {
        this.coverityInstanceUrl = coverityInstanceUrl;
    }

    public String getProjectName() {
        if (StringUtils.isBlank((CharSequence)this.projectName)) {
            return null;
        }
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getViewName() {
        if (StringUtils.isBlank((CharSequence)this.viewName)) {
            return null;
        }
        return this.viewName;
    }

    @DataBoundSetter
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public Boolean getMarkUnstable() {
        if (Boolean.FALSE.equals(this.markUnstable)) {
            return null;
        }
        return this.markUnstable;
    }

    @DataBoundSetter
    public void setMarkUnstable(Boolean markUnstable) {
        this.markUnstable = markUnstable;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context);
    }

    public class Execution
    extends SynchronousNonBlockingStepExecution<Integer> {
        private static final long serialVersionUID = -5807577350749324767L;
        private final transient TaskListener listener;
        private final transient EnvVars envVars;
        private final transient Node node;
        private final transient Launcher launcher;
        private final transient Run<?, ?> run;
        private final transient FlowNode flowNode;

        protected Execution(StepContext context) throws InterruptedException, IOException {
            super(context);
            this.listener = (TaskListener)context.get(TaskListener.class);
            this.envVars = (EnvVars)context.get(EnvVars.class);
            this.node = (Node)context.get(Node.class);
            this.launcher = (Launcher)context.get(Launcher.class);
            this.run = (Run)context.get(Run.class);
            this.flowNode = (FlowNode)context.get(FlowNode.class);
        }

        protected Integer run() throws Exception {
            String resolvedCredentialsId;
            CoverityWorkflowStepFactory coverityWorkflowStepFactory = new CoverityWorkflowStepFactory(this.envVars, this.node, this.launcher, this.listener);
            CoverityJenkinsIntLogger logger = coverityWorkflowStepFactory.getOrCreateLogger();
            IntEnvironmentVariables intEnvironmentVariables = coverityWorkflowStepFactory.getOrCreateEnvironmentVariables();
            String unresolvedCoverityInstanceUrl = this.getRequiredValueOrDie(CheckForIssuesStep.this.coverityInstanceUrl, CheckForIssuesStep.FIELD_COVERITY_INSTANCE_URL, JenkinsCoverityEnvironmentVariable.COVERITY_URL, arg_0 -> ((IntEnvironmentVariables)intEnvironmentVariables).getValue(arg_0));
            String resolvedCoverityInstanceUrl = Util.replaceMacro((String)unresolvedCoverityInstanceUrl, (Map)intEnvironmentVariables.getVariables());
            String unresolvedProjectName = this.getRequiredValueOrDie(CheckForIssuesStep.this.projectName, CheckForIssuesStep.FIELD_PROJECT_NAME, JenkinsCoverityEnvironmentVariable.COVERITY_PROJECT, arg_0 -> ((IntEnvironmentVariables)intEnvironmentVariables).getValue(arg_0));
            String resolvedProjectName = Util.replaceMacro((String)unresolvedProjectName, (Map)intEnvironmentVariables.getVariables());
            String unresolvedViewName = this.getRequiredValueOrDie(CheckForIssuesStep.this.viewName, CheckForIssuesStep.FIELD_VIEW_NAME, JenkinsCoverityEnvironmentVariable.COVERITY_VIEW, arg_0 -> ((IntEnvironmentVariables)intEnvironmentVariables).getValue(arg_0));
            String resolvedViewName = Util.replaceMacro((String)unresolvedViewName, (Map)intEnvironmentVariables.getVariables());
            JenkinsVersionHelper jenkinsVersionHelper = JenkinsWrapper.initializeFromJenkinsJVM().getVersionHelper();
            Optional<String> possibleCredentialsId = this.getValueFromStepOrEnvironment(CheckForIssuesStep.this.credentialsId, JenkinsCoverityEnvironmentVariable.CREDENTIALS_ID, arg_0 -> ((IntEnvironmentVariables)intEnvironmentVariables).getValue(arg_0));
            if (possibleCredentialsId.isPresent()) {
                resolvedCredentialsId = possibleCredentialsId.get();
            } else {
                CoverityConnectInstance coverityConnectInstance = coverityWorkflowStepFactory.getCoverityConnectInstanceFromUrl(resolvedCoverityInstanceUrl);
                resolvedCredentialsId = coverityConnectInstance.getDefaultCredentialsId();
            }
            CheckForIssuesStepWorkflow checkForIssuesStepWorkflow = new CheckForIssuesStepWorkflow(logger, jenkinsVersionHelper, (ThrowingSupplier<WebServiceFactory, CoverityJenkinsAbortException>)((ThrowingSupplier)() -> coverityWorkflowStepFactory.getWebServiceFactoryFromUrl(resolvedCoverityInstanceUrl, resolvedCredentialsId)), coverityWorkflowStepFactory, resolvedCoverityInstanceUrl, resolvedCredentialsId, resolvedProjectName, resolvedViewName, CheckForIssuesStep.this.returnIssueCount, CheckForIssuesStep.this.markUnstable, this.run, this.flowNode);
            return checkForIssuesStepWorkflow.perform();
        }

        private Optional<String> getValueFromStepOrEnvironment(String pipelineParameter, JenkinsCoverityEnvironmentVariable environmentVariable, UnaryOperator<String> getter) {
            if (StringUtils.isNotBlank((CharSequence)pipelineParameter)) {
                return Optional.of(pipelineParameter);
            }
            String valueFromEnvironmentVariable = (String)getter.apply(environmentVariable.toString());
            if (StringUtils.isNotBlank((CharSequence)valueFromEnvironmentVariable)) {
                return Optional.of(valueFromEnvironmentVariable);
            }
            return Optional.empty();
        }

        private String getRequiredValueOrDie(String pipelineParameter, String parameterName, JenkinsCoverityEnvironmentVariable environmentVariable, UnaryOperator<String> getter) throws AbortException {
            return this.getValueFromStepOrEnvironment(pipelineParameter, environmentVariable, getter).orElseThrow(() -> new AbortException("Coverity issue check failed because required parameter " + parameterName + " was not set. Please set " + parameterName + " or populate $" + environmentVariable.toString() + " with the desired value."));
        }
    }

    @Symbol(value={"coverityIssueCheck"})
    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        private final CoverityConnectionFieldHelper coverityConnectionFieldHelper;
        private final ProjectStreamFieldHelper projectStreamFieldHelper;
        private final IssueViewFieldHelper issueViewFieldHelper;
        private final SynopsysCoverityCredentialsHelper credentialsHelper;

        public DescriptorImpl() {
            Slf4jIntLogger slf4jIntLogger = new Slf4jIntLogger(LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
            this.coverityConnectionFieldHelper = new CoverityConnectionFieldHelper((IntLogger)slf4jIntLogger);
            this.projectStreamFieldHelper = new ProjectStreamFieldHelper((IntLogger)slf4jIntLogger);
            this.issueViewFieldHelper = new IssueViewFieldHelper((IntLogger)slf4jIntLogger);
            this.credentialsHelper = new SynopsysCoverityCredentialsHelper((IntLogger)slf4jIntLogger, JenkinsWrapper.initializeFromJenkinsJVM());
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(TaskListener.class, EnvVars.class));
        }

        public String getFunctionName() {
            return CheckForIssuesStep.PIPELINE_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return CheckForIssuesStep.DISPLAY_NAME;
        }

        @POST
        public ListBoxModel doFillCoverityInstanceUrlItems(@AncestorInPath Item item) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doFillCoverityInstanceUrlItems();
        }

        @POST
        public FormValidation doCheckCoverityInstanceUrl(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrl(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.credentialsHelper.listSupportedCredentials();
        }

        @POST
        public ListBoxModel doFillProjectNameItems(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="updateNow") boolean updateNow) throws InterruptedException {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            if (updateNow) {
                this.projectStreamFieldHelper.updateNow(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
            }
            return this.projectStreamFieldHelper.getProjectNamesForListBox(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrlIgnoreMessage(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public ListBoxModel doFillViewNameItems(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="updateNow") boolean updateNow) throws InterruptedException {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            if (updateNow) {
                this.issueViewFieldHelper.updateNow(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
            }
            return this.issueViewFieldHelper.getViewNamesForListBox(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }

        @POST
        public FormValidation doCheckViewName(@AncestorInPath Item item, @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="credentialsId") String credentialsId) {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrlIgnoreMessage(coverityInstanceUrl, StringUtils.isNotBlank((CharSequence)credentialsId), credentialsId);
        }
    }
}

