/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.buildstep;

import com.synopsys.integration.jenkins.coverity.JenkinsCoverityEnvironmentVariable;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RepeatableCommand
extends AbstractDescribableImpl<RepeatableCommand> {
    private final String command;

    @DataBoundConstructor
    public RepeatableCommand(String command) {
        this.command = command;
    }

    public static RepeatableCommand COV_BUILD(String buildCommand, String arguments) {
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.add("cov-build");
        commandPieces.add(Argument.DIR.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_INTERMEDIATE_DIRECTORY.expansionString());
        if (StringUtils.isNotBlank((CharSequence)arguments)) {
            commandPieces.add(arguments);
        }
        if (StringUtils.isNotBlank((CharSequence)buildCommand)) {
            commandPieces.add(buildCommand);
        }
        return RepeatableCommand.constructCommand(commandPieces);
    }

    public static RepeatableCommand COV_ANALYZE(String arguments) {
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.add("cov-analyze");
        commandPieces.add(Argument.DIR.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_INTERMEDIATE_DIRECTORY.expansionString());
        if (StringUtils.isNotBlank((CharSequence)arguments)) {
            commandPieces.add(arguments);
        }
        return RepeatableCommand.constructCommand(commandPieces);
    }

    public static RepeatableCommand COV_RUN_DESKTOP(String authKeyFilePath, String arguments) {
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.add("cov-run-desktop");
        commandPieces.add(Argument.DIR.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_INTERMEDIATE_DIRECTORY.expansionString());
        commandPieces.add(Argument.URL.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_URL.expansionString());
        commandPieces.add(Argument.STREAM.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_STREAM.expansionString());
        if (StringUtils.isNotBlank((CharSequence)authKeyFilePath)) {
            commandPieces.add(Argument.AUTH_KEY_FILE.toString());
            commandPieces.add(authKeyFilePath);
        }
        if (StringUtils.isNotBlank((CharSequence)arguments)) {
            commandPieces.add(arguments);
        }
        commandPieces.add(JenkinsCoverityEnvironmentVariable.CHANGE_SET.expansionString());
        return RepeatableCommand.constructCommand(commandPieces);
    }

    public static RepeatableCommand COV_COMMIT_DEFECTS(String authKeyFilePath, String arguments) {
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.add("cov-commit-defects");
        commandPieces.add(Argument.DIR.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_INTERMEDIATE_DIRECTORY.expansionString());
        commandPieces.add(Argument.URL.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_URL.expansionString());
        commandPieces.add(Argument.STREAM.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_STREAM.expansionString());
        if (StringUtils.isNotBlank((CharSequence)authKeyFilePath)) {
            commandPieces.add(Argument.AUTH_KEY_FILE.toString());
            commandPieces.add(authKeyFilePath);
        }
        if (StringUtils.isNotBlank((CharSequence)arguments)) {
            commandPieces.add(arguments);
        }
        return RepeatableCommand.constructCommand(commandPieces);
    }

    public static RepeatableCommand COV_CAPTURE_PROJECT(String projectDir, String arguments) {
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.add("cov-capture");
        if (StringUtils.isNotBlank((CharSequence)projectDir)) {
            commandPieces.add(Argument.PROJECT_DIR.toString());
            commandPieces.add(projectDir);
        }
        commandPieces.add(Argument.DIR.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_INTERMEDIATE_DIRECTORY.expansionString());
        if (StringUtils.isNotBlank((CharSequence)arguments)) {
            commandPieces.add(arguments);
        }
        return RepeatableCommand.constructCommand(commandPieces);
    }

    public static RepeatableCommand COV_CAPTURE_SCM(String scmUrl, String arguments) {
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.add("cov-capture");
        if (StringUtils.isNotBlank((CharSequence)scmUrl)) {
            commandPieces.add(Argument.SCM_URL.toString());
            commandPieces.add(scmUrl);
        }
        commandPieces.add(Argument.DIR.toString());
        commandPieces.add(JenkinsCoverityEnvironmentVariable.COVERITY_INTERMEDIATE_DIRECTORY.expansionString());
        if (StringUtils.isNotBlank((CharSequence)arguments)) {
            commandPieces.add(arguments);
        }
        return RepeatableCommand.constructCommand(commandPieces);
    }

    private static RepeatableCommand constructCommand(List<String> commandPieces) {
        String command = commandPieces.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(" "));
        return new RepeatableCommand(command);
    }

    public String getCommand() {
        return this.command;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepeatableCommand> {
        public DescriptorImpl() {
            super(RepeatableCommand.class);
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckCommand(@QueryParameter(value="command") String command) {
            if (StringUtils.isBlank((CharSequence)command)) {
                return FormValidation.error((String)"The Coverity command can not be empty");
            }
            return FormValidation.ok();
        }
    }

    public static enum Argument {
        DIR("--dir"),
        PROJECT_DIR("--project-dir"),
        URL("--url"),
        SCM_URL("--scm-url"),
        STREAM("--stream"),
        AUTH_KEY_FILE("--auth-key-file");

        private final String text;

        private Argument(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

