/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.buildstep;

import com.synopsys.integration.coverity.api.rest.ViewContents;
import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.coverity.ws.view.ViewReportWrapper;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.function.ThrowingSupplier;
import com.synopsys.integration.jenkins.coverity.JenkinsCoverityEnvironmentVariable;
import com.synopsys.integration.jenkins.coverity.actions.IssueReportAction;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.coverity.extensions.BuildStatus;
import com.synopsys.integration.jenkins.coverity.extensions.CheckForIssuesInView;
import com.synopsys.integration.jenkins.coverity.extensions.CleanUpAction;
import com.synopsys.integration.jenkins.coverity.extensions.ConfigureChangeSetPatterns;
import com.synopsys.integration.jenkins.coverity.extensions.CoverityAnalysisType;
import com.synopsys.integration.jenkins.coverity.extensions.OnCommandFailure;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.CoverityRunConfiguration;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.SimpleCoverityRunConfiguration;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CleanUpWorkflowService;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityJenkinsStepWorkflow;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityWorkflowStepFactory;
import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.stepworkflow.StepWorkflow;
import com.synopsys.integration.stepworkflow.StepWorkflowResponse;
import com.synopsys.integration.stepworkflow.SubStep;
import com.synopsys.integration.util.IntEnvironmentVariables;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class CoverityBuildStepWorkflow
extends CoverityJenkinsStepWorkflow<Object> {
    private final CoverityWorkflowStepFactory coverityWorkflowStepFactory;
    private final AbstractBuild<?, ?> build;
    private final String projectName;
    private final String streamName;
    private final CoverityRunConfiguration coverityRunConfiguration;
    @Nullable
    private final ConfigureChangeSetPatterns configureChangeSetPatterns;
    @Nullable
    private final CheckForIssuesInView checkForIssuesInView;
    private final OnCommandFailure onCommandFailure;
    private final CleanUpAction cleanUpAction;
    private final String workspaceRemotePath;
    private final String coverityInstanceUrl;
    private final String credentialsId;

    public CoverityBuildStepWorkflow(JenkinsIntLogger logger, JenkinsVersionHelper jenkinsVersionHelper, ThrowingSupplier<WebServiceFactory, CoverityJenkinsAbortException> webServiceFactorySupplier, CoverityWorkflowStepFactory coverityWorkflowStepFactory, AbstractBuild<?, ?> build, String workspaceRemotePath, String coverityInstanceUrl, String credentialsId, String projectName, String streamName, CoverityRunConfiguration coverityRunConfiguration, ConfigureChangeSetPatterns configureChangeSetPatterns, CheckForIssuesInView checkForIssuesInView, OnCommandFailure onCommandFailure, CleanUpAction cleanUpAction) {
        super(logger, jenkinsVersionHelper, webServiceFactorySupplier);
        this.coverityWorkflowStepFactory = coverityWorkflowStepFactory;
        this.build = build;
        this.workspaceRemotePath = workspaceRemotePath;
        this.coverityInstanceUrl = coverityInstanceUrl;
        this.credentialsId = credentialsId;
        this.projectName = projectName;
        this.streamName = streamName;
        this.coverityRunConfiguration = coverityRunConfiguration;
        this.configureChangeSetPatterns = configureChangeSetPatterns;
        this.checkForIssuesInView = checkForIssuesInView;
        this.onCommandFailure = onCommandFailure;
        this.cleanUpAction = cleanUpAction;
    }

    protected StepWorkflow<Object> buildWorkflow() throws AbortException {
        String viewName = Optional.ofNullable(this.checkForIssuesInView).map(CheckForIssuesInView::getViewName).orElse("");
        BuildStatus buildStatus = Optional.ofNullable(this.checkForIssuesInView).map(CheckForIssuesInView::getBuildStatusForIssues).orElse(BuildStatus.SUCCESS);
        boolean shouldValidateVersion = CoverityRunConfiguration.RunConfigurationType.SIMPLE.equals((Object)this.coverityRunConfiguration.getRunConFigurationType());
        return StepWorkflow.first(this.coverityWorkflowStepFactory.createStepValidateCoverityInstallation(shouldValidateVersion)).then(this.coverityWorkflowStepFactory.createStepCreateAuthenticationKeyFile(this.workspaceRemotePath, this.coverityInstanceUrl, this.credentialsId)).then((SubStep)this.coverityWorkflowStepFactory.createStepSetUpCoverityEnvironment(this.build.getChangeSets(), this.configureChangeSetPatterns, this.workspaceRemotePath, this.coverityInstanceUrl, this.credentialsId, this.projectName, this.streamName, viewName)).then((SubStep)this.coverityWorkflowStepFactory.createStepCreateMissingProjectsAndStreams(this.coverityInstanceUrl, this.credentialsId, this.projectName, this.streamName)).andSometimes((SubStep)this.coverityWorkflowStepFactory.createStepGetCoverityCommands(this.coverityRunConfiguration)).then((SubStep)this.coverityWorkflowStepFactory.createStepRunCoverityCommands(this.workspaceRemotePath, this.onCommandFailure)).butOnlyIf((Object)this.coverityWorkflowStepFactory.getOrCreateEnvironmentVariables(), intEnvironmentVariables -> this.shouldRunCoverityCommands((IntEnvironmentVariables)intEnvironmentVariables, this.coverityRunConfiguration)).andSometimes((SubStep)this.coverityWorkflowStepFactory.createStepGetIssuesInView(this.coverityInstanceUrl, this.credentialsId, this.projectName, viewName)).then(SubStep.ofConsumer(viewReportWrapper -> this.handleIssues((ViewReportWrapper)viewReportWrapper, this.build, this.projectName, viewName, buildStatus))).butOnlyIf((Object)this.checkForIssuesInView, Objects::nonNull).build();
    }

    public Boolean perform() throws AbortException {
        StepWorkflowResponse stepWorkflowResponse = this.runWorkflow();
        boolean wasSuccessful = stepWorkflowResponse.wasSuccessful();
        try {
            if (!wasSuccessful) {
                throw stepWorkflowResponse.getException();
            }
        }
        catch (InterruptedException e) {
            this.logger.error("[ERROR] Synopsys Coverity thread was interrupted.", (Throwable)e);
            this.build.setResult(Result.ABORTED);
            Thread.currentThread().interrupt();
        }
        catch (IntegrationException e) {
            this.handleException(this.build, Result.FAILURE, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(this.build, Result.UNSTABLE, e);
        }
        return stepWorkflowResponse.wasSuccessful();
    }

    @Override
    public void cleanUp() throws CoverityJenkinsAbortException {
        IntEnvironmentVariables intEnvironmentVariables = this.coverityWorkflowStepFactory.getOrCreateEnvironmentVariables();
        CleanUpWorkflowService cleanUpWorkflowService = new CleanUpWorkflowService(this.logger);
        String authKeyPath = intEnvironmentVariables.getValue(JenkinsCoverityEnvironmentVariable.TEMPORARY_AUTH_KEY_PATH.toString());
        if (StringUtils.isNotBlank((String)authKeyPath)) {
            VirtualChannel virtualChannel = this.coverityWorkflowStepFactory.getOrCreateVirtualChannel();
            FilePath authKeyFile = new FilePath(virtualChannel, authKeyPath);
            cleanUpWorkflowService.cleanUpAuthenticationFile(authKeyFile);
        }
        if (CleanUpAction.DELETE_INTERMEDIATE_DIRECTORY.equals((Object)this.cleanUpAction)) {
            FilePath intermediateDirectory = this.coverityWorkflowStepFactory.getIntermediateDirectory(this.workspaceRemotePath);
            cleanUpWorkflowService.cleanUpIntermediateDirectory(intermediateDirectory);
        }
    }

    private boolean shouldRunCoverityCommands(IntEnvironmentVariables intEnvironmentVariables, CoverityRunConfiguration coverityRunConfiguration) {
        boolean analysisIsIncremental;
        if (CoverityRunConfiguration.RunConfigurationType.ADVANCED.equals((Object)coverityRunConfiguration.getRunConFigurationType())) {
            analysisIsIncremental = false;
        } else {
            SimpleCoverityRunConfiguration simpleCoverityRunConfiguration = (SimpleCoverityRunConfiguration)coverityRunConfiguration;
            int changeSetSize = Integer.parseInt(intEnvironmentVariables.getValue(JenkinsCoverityEnvironmentVariable.CHANGE_SET_SIZE.toString(), "0"));
            CoverityAnalysisType coverityAnalysisType = simpleCoverityRunConfiguration.getCoverityAnalysisType();
            int changeSetThreshold = simpleCoverityRunConfiguration.getChangeSetAnalysisThreshold();
            analysisIsIncremental = CoverityAnalysisType.COV_RUN_DESKTOP.equals((Object)coverityAnalysisType) || CoverityAnalysisType.THRESHOLD.equals((Object)coverityAnalysisType) && changeSetSize < changeSetThreshold;
        }
        String changeSetString = intEnvironmentVariables.getValue(JenkinsCoverityEnvironmentVariable.CHANGE_SET.toString());
        if (analysisIsIncremental && StringUtils.isBlank((String)changeSetString)) {
            this.logger.alwaysLog("Skipping Synopsys Coverity static analysis because the analysis type was determined to be Incremental Analysis and the Jenkins $CHANGE_SET was empty.");
            return false;
        }
        return true;
    }

    private void handleIssues(ViewReportWrapper viewReportWrapper, AbstractBuild<?, ?> build, String projectName, String viewName, BuildStatus buildStatusOnIssues) {
        this.logger.alwaysLog("Checking for issues in view");
        this.logger.alwaysLog("-- Build state for issues in the view: " + buildStatusOnIssues.getDisplayName());
        this.logger.alwaysLog("-- Coverity project name: " + projectName);
        this.logger.alwaysLog("-- Coverity view name: " + viewName);
        ViewContents viewContents = viewReportWrapper.getViewContents();
        String viewReportUrl = viewReportWrapper.getViewReportUrl();
        int defectCount = viewContents.getTotalRows().intValue();
        build.addAction((Action)new IssueReportAction(defectCount, viewReportUrl));
        this.logger.alwaysLog(String.format("[Coverity] Found %s issues: %s", defectCount, viewReportUrl));
        if (defectCount > 0) {
            this.logger.alwaysLog("Setting build status to " + buildStatusOnIssues.getResult().toString());
            build.setResult(buildStatusOnIssues.getResult());
        }
    }

    private void handleException(AbstractBuild<?, ?> build, Result result, Exception e) {
        this.logger.error("[ERROR] " + e.getMessage());
        this.logger.debug(e.getMessage(), (Throwable)e);
        build.setResult(result);
    }
}

