/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.buildstep;

import com.synopsys.integration.jenkins.coverity.extensions.buildstep.RepeatableCommand;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CommandArguments
extends AbstractDescribableImpl<CommandArguments> {
    private final String covBuildArguments;
    private final String covAnalyzeArguments;
    private final String covRunDesktopArguments;
    private final String covCommitDefectsArguments;
    private final String covCaptureArguments;

    @DataBoundConstructor
    public CommandArguments(String covBuildArguments, String covAnalyzeArguments, String covRunDesktopArguments, String covCommitDefectsArguments, String covCaptureArguments) {
        this.covBuildArguments = covBuildArguments;
        this.covAnalyzeArguments = covAnalyzeArguments;
        this.covRunDesktopArguments = covRunDesktopArguments;
        this.covCommitDefectsArguments = covCommitDefectsArguments;
        this.covCaptureArguments = covCaptureArguments;
    }

    public String getCovBuildArguments() {
        return this.covBuildArguments;
    }

    public String getCovAnalyzeArguments() {
        return this.covAnalyzeArguments;
    }

    public String getCovRunDesktopArguments() {
        return this.covRunDesktopArguments;
    }

    public String getCovCommitDefectsArguments() {
        return this.covCommitDefectsArguments;
    }

    public String getCovCaptureArguments() {
        return this.covCaptureArguments;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CommandArguments> {
        public DescriptorImpl() {
            super(CommandArguments.class);
            this.load();
        }

        public FormValidation doCheckCovBuildArguments(@QueryParameter(value="covBuildArguments") String covBuildArguments) {
            return this.checkForAlreadyProvidedArguments(covBuildArguments, RepeatableCommand.Argument.DIR);
        }

        public FormValidation doCheckCovAnalyzeArguments(@QueryParameter(value="covAnalyzeArguments") String covAnalyzeArguments) {
            return this.checkForAlreadyProvidedArguments(covAnalyzeArguments, RepeatableCommand.Argument.DIR);
        }

        public FormValidation doCheckCovRunDesktopArguments(@QueryParameter(value="covRunDesktopArguments") String covRunDesktopArguments) {
            return this.checkForAlreadyProvidedArguments(covRunDesktopArguments, RepeatableCommand.Argument.DIR, RepeatableCommand.Argument.URL, RepeatableCommand.Argument.STREAM);
        }

        public FormValidation doCheckCovCommitDefectsArguments(@QueryParameter(value="covCommitDefectsArguments") String covCommitDefectsArguments) {
            return this.checkForAlreadyProvidedArguments(covCommitDefectsArguments, RepeatableCommand.Argument.DIR, RepeatableCommand.Argument.URL, RepeatableCommand.Argument.STREAM);
        }

        private FormValidation checkForAlreadyProvidedArguments(String command, RepeatableCommand.Argument ... providedArguments) {
            String alreadyProvidedArguments = Arrays.stream(providedArguments).map(RepeatableCommand.Argument::toString).filter(command::contains).collect(Collectors.joining(", "));
            if (StringUtils.isNotBlank((CharSequence)alreadyProvidedArguments)) {
                return FormValidation.error((String)String.format("The argument(s) %s are automatically provided in this mode. If you wish to override, configure the 'Run custom Coverity commands' section instead.", alreadyProvidedArguments));
            }
            return FormValidation.ok();
        }
    }
}

