/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions;

import com.synopsys.integration.jenkins.coverity.SynopsysCoverityCredentialsHelper;
import com.synopsys.integration.jenkins.coverity.extensions.BuildStatus;
import com.synopsys.integration.jenkins.coverity.extensions.utils.IssueViewFieldHelper;
import com.synopsys.integration.jenkins.extensions.JenkinsSelectBoxEnum;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.Slf4jIntLogger;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.ListBoxModel;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.LoggerFactory;

public class CheckForIssuesInView
extends AbstractDescribableImpl<CheckForIssuesInView> {
    public static final String FIELD_VIEW_NAME = "viewName";
    public static final String FIELD_BUILD_STATUS_FOR_ISSUES = "buildStatusForIssues";
    public static final String PATH_TO_COVERITY_BUILD_STEP = "..";
    private final String viewName;
    private final BuildStatus buildStatusForIssues;

    @DataBoundConstructor
    public CheckForIssuesInView(String viewName, String buildStatusForIssues) {
        this.viewName = viewName;
        this.buildStatusForIssues = BuildStatus.valueOf(buildStatusForIssues);
    }

    public BuildStatus getBuildStatusForIssues() {
        return this.buildStatusForIssues;
    }

    public String getViewName() {
        return this.viewName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CheckForIssuesInView> {
        private final IssueViewFieldHelper issueViewFieldHelper;
        private final SynopsysCoverityCredentialsHelper credentialsHelper;

        public DescriptorImpl() {
            super(CheckForIssuesInView.class);
            this.load();
            Slf4jIntLogger slf4jIntLogger = new Slf4jIntLogger(LoggerFactory.getLogger(CheckForIssuesInView.class));
            this.issueViewFieldHelper = new IssueViewFieldHelper((IntLogger)slf4jIntLogger);
            this.credentialsHelper = new SynopsysCoverityCredentialsHelper((IntLogger)slf4jIntLogger, JenkinsWrapper.initializeFromJenkinsJVM());
        }

        @POST
        public ListBoxModel doFillViewNameItems(@AncestorInPath Item item, @RelativePath(value="..") @QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @RelativePath(value="..") @QueryParameter(value="overrideDefaultCredentials") Boolean overrideDefaultCredentials, @RelativePath(value="..") @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="updateNow") boolean updateNow) throws InterruptedException {
            this.credentialsHelper.checkPermissionToAccessCredentials(item);
            if (updateNow) {
                this.issueViewFieldHelper.updateNow(coverityInstanceUrl, overrideDefaultCredentials, credentialsId);
            }
            return this.issueViewFieldHelper.getViewNamesForListBox(coverityInstanceUrl, overrideDefaultCredentials, credentialsId);
        }

        public ListBoxModel doFillBuildStatusForIssuesItems() {
            return JenkinsSelectBoxEnum.toListBoxModel((JenkinsSelectBoxEnum[])BuildStatus.values());
        }
    }
}

