/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.synopsys.integration.coverity.authentication.AuthenticationKeyFile;
import com.synopsys.integration.coverity.authentication.AuthenticationKeyFileUtility;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.jenkins.wrapper.SynopsysCredentialsHelper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.SilentIntLogger;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.credentials.CredentialsBuilder;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jetbrains.annotations.Nullable;

public class SynopsysCoverityCredentialsHelper
extends SynopsysCredentialsHelper {
    public static final Class<FileCredentials> AUTH_KEY_FILE_CREDENTIALS_CLASS = FileCredentials.class;
    public static final CredentialsMatcher AUTH_KEY_FILE_CREDENTIALS = CredentialsMatchers.instanceOf(AUTH_KEY_FILE_CREDENTIALS_CLASS);
    public static final CredentialsMatcher SUPPORTED_CREDENTIALS_TYPES = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{AUTH_KEY_FILE_CREDENTIALS, CredentialsMatchers.instanceOf((Class)USERNAME_PASSWORD_CREDENTIALS_CLASS)});
    private final IntLogger logger;
    private final JenkinsWrapper jenkinsWrapper;

    public SynopsysCoverityCredentialsHelper(IntLogger logger, JenkinsWrapper jenkinsWrapper) {
        super(jenkinsWrapper);
        this.jenkinsWrapper = jenkinsWrapper;
        this.logger = logger;
    }

    public static SynopsysCoverityCredentialsHelper silentHelper(JenkinsWrapper jenkinsWrapper) {
        return new SynopsysCoverityCredentialsHelper((IntLogger)new SilentIntLogger(), jenkinsWrapper);
    }

    public ListBoxModel listSupportedCredentials() {
        Optional optionalJenkins = this.jenkinsWrapper.getJenkins();
        if (optionalJenkins.isPresent()) {
            Jenkins jenkins = (Jenkins)optionalJenkins.get();
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, StandardCredentials.class, Collections.emptyList(), SUPPORTED_CREDENTIALS_TYPES);
        }
        return new StandardListBoxModel().includeEmptyValue();
    }

    public Optional<FileCredentials> getAuthenticationKeyFileCredentialsById(String credentialsId) {
        return this.getCredentialsById(AUTH_KEY_FILE_CREDENTIALS_CLASS, credentialsId);
    }

    public Optional<String> getCoverityUsernameById(String credentialsId) {
        return this.getIntegrationCredentialsById(credentialsId).getUsername();
    }

    public Optional<String> getCoverityPassphraseById(String credentialsId) {
        return this.getUsernamePasswordCredentialsById(credentialsId).map(UsernamePasswordCredentialsImpl::getPassword).map(Secret::getPlainText);
    }

    public Credentials getIntegrationCredentialsById(String credentialsId) {
        Optional possibleUsernamePasswordCredentials = this.getUsernamePasswordCredentialsById(credentialsId);
        Optional<FileCredentials> possibleAuthKeyCredentials = this.getAuthenticationKeyFileCredentialsById(credentialsId);
        CredentialsBuilder credentialsBuilder = Credentials.newBuilder();
        if (possibleUsernamePasswordCredentials.isPresent()) {
            UsernamePasswordCredentialsImpl usernamePasswordCredentials = (UsernamePasswordCredentialsImpl)possibleUsernamePasswordCredentials.get();
            credentialsBuilder.setUsernameAndPassword(usernamePasswordCredentials.getUsername(), usernamePasswordCredentials.getPassword().getPlainText());
        }
        if (possibleAuthKeyCredentials.isPresent()) {
            FileCredentials fileCredentials = possibleAuthKeyCredentials.get();
            AuthenticationKeyFileUtility authenticationKeyFileUtility = AuthenticationKeyFileUtility.defaultUtility();
            try (InputStream keyFileInputStream = fileCredentials.getContent();){
                AuthenticationKeyFile authenticationKeyFile = authenticationKeyFileUtility.readAuthenticationKeyFile(keyFileInputStream);
                credentialsBuilder.setUsernameAndPassword(authenticationKeyFile.username, authenticationKeyFile.key);
            }
            catch (IOException e) {
                this.logger.trace("Could not parse authentication key file with credentials id " + credentialsId + " because: ", (Throwable)e);
            }
        }
        return (Credentials)credentialsBuilder.build();
    }

    public void checkPermissionToAccessCredentials(Item item) {
        Jenkins jenkins = this.getJenkins();
        if (jenkins == null) {
            throw new RuntimeException("Jenkins instance is null");
        }
        if (item == null) {
            jenkins.checkPermission(Jenkins.ADMINISTER);
        } else {
            item.checkPermission(Item.EXTENDED_READ);
            item.checkPermission(CredentialsProvider.USE_ITEM);
        }
    }

    @Nullable
    private Jenkins getJenkins() {
        Optional optionalJenkins = this.jenkinsWrapper.getJenkins();
        if (optionalJenkins.isPresent()) {
            return (Jenkins)optionalJenkins.get();
        }
        return null;
    }
}

